/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.editor.SingleWindowInspector;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class LightInspector
extends SingleWindowInspector {
    public static final Component TITLE = Component.translatable((String)"inspector.veil.light.title");
    private static final Component ADD = Component.translatable((String)"inspector.veil.light.button.add");
    private static final Component REMOVE = Component.translatable((String)"inspector.veil.light.button.remove");
    private static final Component REMOVE_ALL = Component.translatable((String)"inspector.veil.light.button.remove_all");
    private static final Component REMOVE_ALL_DESC = Component.translatable((String)"inspector.veil.light.button.remove_all.desc");
    private static final Component SET_POSITION = Component.translatable((String)"inspector.veil.light.button.set_position");
    private static final Component ATTRIBUTES = Component.translatable((String)"inspector.veil.light.attributes");
    private static final Component ENABLE_AO = Component.translatable((String)"inspector.veil.light.toggle.ao");
    private final List<ResourceKey<LightTypeRegistry.LightType<?>>> lightTypes = new ArrayList();
    private ResourceKey<LightTypeRegistry.LightType<?>> selectedTab;
    private final ImBoolean enableAmbientOcclusion = new ImBoolean();

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    @Nullable
    public Component getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    public boolean isEnabled() {
        return Minecraft.getInstance().level != null && LightTypeRegistry.REGISTRY.size() > 0;
    }

    @Override
    protected void renderComponents() {
        LightTypeRegistry.LightType lightType;
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getLightRenderer();
        if (this.selectedTab == null || !LightTypeRegistry.REGISTRY.containsKey(this.selectedTab)) {
            this.selectedTab = this.lightTypes.getFirst();
        }
        ImGui.beginDisabled(((lightType = (LightTypeRegistry.LightType)LightTypeRegistry.REGISTRY.get(this.selectedTab)) == null || lightType.debugLightFactory() == null ? 1 : 0) != 0);
        if (ImGui.button((String)ADD.getString()) && lightType != null && lightType.debugLightFactory() != null) {
            LightTypeRegistry.DebugLightFactory factory = lightType.debugLightFactory();
            Minecraft minecraft = Minecraft.getInstance();
            Camera mainCamera = minecraft.gameRenderer.getMainCamera();
            lightRenderer.addLight(factory.createDebugLight(minecraft.level, mainCamera));
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered((int)0)) {
            VeilImGuiUtil.setTooltip((FormattedText)Component.translatable((String)"inspector.veil.light.button.add.desc", (Object[])new Object[]{this.selectedTab.location().toString()}));
        }
        ImGui.sameLine();
        ImGui.beginDisabled((lightType == null ? 1 : 0) != 0);
        if (ImGui.button((String)REMOVE.getString()) && lightType != null) {
            for (LightRenderHandle lightRenderHandle : lightRenderer.getLights(lightType)) {
                lightRenderHandle.free();
            }
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered((int)0)) {
            VeilImGuiUtil.setTooltip((FormattedText)Component.translatable((String)"inspector.veil.light.button.remove.desc", (Object[])new Object[]{this.selectedTab.location().toString()}));
        }
        ImGui.sameLine();
        if (ImGui.button((String)REMOVE_ALL.getString())) {
            lightRenderer.free();
        }
        if (ImGui.isItemHovered((int)0)) {
            VeilImGuiUtil.setTooltip((FormattedText)REMOVE_ALL_DESC);
        }
        ImGui.sameLine();
        this.enableAmbientOcclusion.set(lightRenderer.isAmbientOcclusionEnabled());
        if (ImGui.checkbox((String)ENABLE_AO.getString(), (ImBoolean)this.enableAmbientOcclusion)) {
            if (this.enableAmbientOcclusion.get()) {
                lightRenderer.enableAmbientOcclusion();
            } else {
                lightRenderer.disableAmbientOcclusion();
            }
        }
        if (ImGui.isItemHovered()) {
            ImGui.setTooltip((String)"Deprecated");
        }
        ImGui.beginTabBar((String)"##lights");
        for (ResourceKey resourceKey : this.lightTypes) {
            ResourceLocation id = resourceKey.location();
            if (!ImGui.beginTabItem((String)id.toString())) continue;
            this.selectedTab = resourceKey;
            int i = 0;
            Collection lightData = lightRenderer.getLights((LightTypeRegistry.LightType)LightTypeRegistry.REGISTRY.get(resourceKey));
            for (LightRenderHandle handle : lightData) {
                ImGui.pushID((String)("light" + i));
                LightInspector.renderLightComponents(handle);
                ImGui.popID();
                ++i;
            }
            ImGui.endTabItem();
        }
        ImGui.endTabBar();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.lightTypes.clear();
        this.lightTypes.addAll(LightTypeRegistry.REGISTRY.registryKeySet().stream().sorted(Comparator.comparing(ResourceKey::location)).toList());
    }

    private static void renderLightComponents(LightRenderHandle<?> handle) {
        Object data = handle.getLightData();
        ImBoolean visible = new ImBoolean(true);
        ImGui.pushID((int)data.hashCode());
        if (ImGui.collapsingHeader((String)DebugEntityNameGenerator.getEntityName((UUID)new UUID(data.hashCode(), 0L)), (ImBoolean)visible)) {
            LightInspector.renderLightAttributeComponents(data);
            handle.markDirty();
        }
        ImGui.popID();
        if (!visible.get()) {
            handle.free();
        }
        ImGui.separator();
    }

    private static void renderLightAttributeComponents(LightData lightData) {
        Color lightColor = lightData.getColor();
        float[] editBrightness = new float[]{lightData.getBrightness()};
        float[] editLightColor = new float[]{lightColor.red(), lightColor.green(), lightColor.blue()};
        ImGui.indent();
        if (ImGui.dragScalar((String)"brightness", (float[])editBrightness, (float)0.02f)) {
            lightData.setBrightness(editBrightness[0]);
        }
        if (ImGui.colorEdit3((String)"color", (float[])editLightColor)) {
            lightData.setColor(editLightColor[0], editLightColor[1], editLightColor[2]);
        }
        if (ImGui.button((String)SET_POSITION.getString())) {
            lightData.setTo(Minecraft.getInstance().gameRenderer.getMainCamera());
        }
        ImGui.newLine();
        VeilImGuiUtil.component((FormattedText)ATTRIBUTES);
        if (lightData instanceof EditorAttributeProvider) {
            EditorAttributeProvider editorAttributeProvider = (EditorAttributeProvider)((Object)lightData);
            editorAttributeProvider.renderImGuiAttributes();
        }
        ImGui.unindent();
    }
}

