/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowInspector;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.post.PostProcessingManager;
import imgui.ImGui;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PostInspector
extends SingleWindowInspector {
    public static final Component TITLE = Component.translatable((String)"inspector.veil.post.title");
    private static final Component INACTIVE = Component.translatable((String)"inspector.veil.post.inactive");
    private static final Component ACTIVE = Component.translatable((String)"inspector.veil.post.active");
    private final Set<ResourceLocation> removedPipelines = new HashSet<ResourceLocation>(1);

    private static boolean isInternal(ResourceLocation id) {
        return "veil".equals(id.getNamespace()) && id.getPath().startsWith("core/");
    }

    @Override
    public void render() {
        ImGui.setNextWindowSize((float)600.0f, (float)0.0f);
        super.render();
    }

    @Override
    public void renderComponents() {
        ResourceLocation payload;
        this.removedPipelines.clear();
        PostProcessingManager postProcessingManager = VeilRenderSystem.renderer().getPostProcessingManager();
        float availableWidth = ImGui.getContentRegionAvailX();
        ImGui.setNextItemWidth((float)(availableWidth / 2.0f));
        ImGui.beginGroup();
        VeilImGuiUtil.component((FormattedText)INACTIVE);
        if (ImGui.beginListBox((String)"##available_pipelines", (float)(availableWidth / 2.0f), (float)0.0f)) {
            for (ResourceLocation entry : postProcessingManager.getPipelines()) {
                if (postProcessingManager.isActive(entry) || PostInspector.isInternal(entry)) continue;
                VeilImGuiUtil.resourceLocation(entry);
                if (!ImGui.beginDragDropSource((int)8)) continue;
                ImGui.setDragDropPayload((String)"INACTIVE_POST_PIPELINE", (Object)entry, (int)2);
                VeilImGuiUtil.resourceLocation(entry);
                ImGui.endDragDropSource();
            }
            ImGui.endListBox();
        }
        if (ImGui.beginDragDropTarget()) {
            payload = (ResourceLocation)ImGui.acceptDragDropPayload((String)"ACTIVE_POST_PIPELINE");
            if (payload != null) {
                this.removedPipelines.add(payload);
            }
            ImGui.endDragDropTarget();
        }
        ImGui.endGroup();
        ImGui.sameLine();
        ImGui.setNextItemWidth((float)(availableWidth / 2.0f));
        ImGui.beginGroup();
        VeilImGuiUtil.component((FormattedText)ACTIVE);
        if (ImGui.beginListBox((String)"##shaders", (float)(availableWidth / 2.0f), (float)0.0f)) {
            List<PostProcessingManager.ProfileEntry> pipelines = postProcessingManager.getActivePipelines();
            ResourceLocation[] names = new ResourceLocation[pipelines.size()];
            int i = 0;
            ListIterator<PostProcessingManager.ProfileEntry> iterator = pipelines.listIterator(pipelines.size());
            while (iterator.hasPrevious()) {
                names[i++] = iterator.previous().getPipeline();
            }
            for (int j = 0; j < names.length; ++j) {
                ResourceLocation id = names[j];
                ImGui.pushID((String)id.toString());
                VeilImGuiUtil.resourceLocation(id);
                if (ImGui.beginDragDropSource((int)8)) {
                    ImGui.setDragDropPayload((String)"ACTIVE_POST_PIPELINE", (Object)id, (int)2);
                    VeilImGuiUtil.resourceLocation(id);
                    ImGui.endDragDropSource();
                }
                if (ImGui.beginDragDropTarget()) {
                    ResourceLocation payload2 = (ResourceLocation)ImGui.acceptDragDropPayload((String)"ACTIVE_POST_PIPELINE");
                    if (payload2 != null) {
                        int oldIndex;
                        for (oldIndex = 0; oldIndex < names.length && !names[oldIndex].equals((Object)payload2); ++oldIndex) {
                        }
                        for (int k = 0; k < names.length; ++k) {
                            if (k == j) {
                                postProcessingManager.add(1001 + k, payload2);
                                continue;
                            }
                            if (k == oldIndex) {
                                postProcessingManager.add(1001 + k, id);
                                continue;
                            }
                            postProcessingManager.add(1001 + k, names[k]);
                        }
                    }
                    ImGui.endDragDropTarget();
                }
                ImGui.popID();
            }
            ImGui.endListBox();
        }
        if (ImGui.beginDragDropTarget()) {
            payload = (ResourceLocation)ImGui.acceptDragDropPayload((String)"INACTIVE_POST_PIPELINE");
            if (payload != null) {
                postProcessingManager.add(1000, payload);
            }
            ImGui.endDragDropTarget();
        }
        ImGui.endGroup();
        for (ResourceLocation id : this.removedPipelines) {
            postProcessingManager.remove(id);
        }
    }

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return RENDERER_GROUP;
    }
}

