/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.SingleWindowInspector;
import foundry.veil.api.client.imgui.CodeEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.imgui.VeilLanguageDefinitions;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.program.ShaderUniformCache;
import foundry.veil.api.compat.IrisCompat;
import foundry.veil.api.compat.SodiumCompat;
import foundry.veil.impl.client.editor.DeviceInfoViewer;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.mixin.debug.accessor.DebugGameRendererAccessor;
import foundry.veil.mixin.debug.accessor.DebugLevelRendererAccessor;
import foundry.veil.mixin.debug.accessor.DebugPostChainAccessor;
import imgui.ImGui;
import imgui.ImGuiListClipper;
import imgui.callback.ImListClipperCallback;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBProgramInterfaceQuery;
import org.lwjgl.opengl.GL40C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class ShaderInspector
extends SingleWindowInspector
implements ResourceManagerReloadListener {
    public static final Component TITLE = Component.translatable((String)"inspector.veil.shader.title");
    private static final Component REFRESH = Component.translatable((String)"inspector.veil.shader.button.refresh");
    private static final Component SEARCH = Component.translatable((String)"inspector.veil.shader.search");
    private static final Component SHADER_PROGRAMS = Component.translatable((String)"inspector.veil.shader.shader_programs");
    private static final Component SHADER_DEFINITIONS = Component.translatable((String)"inspector.veil.shader.definitions");
    private static final Component SHADER_DEFINITIONS_HINT = Component.translatable((String)"inspector.veil.shader.definitions.hint");
    private static final Component OPEN_SOURCE = Component.translatable((String)"inspector.veil.shader.open_source");
    private static final Component OPEN_SHADER_INFO = Component.translatable((String)"inspector.veil.shader.open_shader_info");
    private static final Component SHADER_INFO_WINDOW = Component.translatable((String)"inspector.veil.shader.shader_info");
    private static final Component SAMPLERS = Component.translatable((String)"inspector.veil.shader.samplers");
    private static final Component UNIFORMS = Component.translatable((String)"inspector.veil.shader.uniforms");
    private static final Component UNIFORM_BLOCKS = Component.translatable((String)"inspector.veil.shader.uniform_blocks");
    private static final Component STORAGE_BLOCKS = Component.translatable((String)"inspector.veil.shader.storage_blocks");
    private final CodeEditor codeEditor;
    private final ImBoolean shaderInfoVisible;
    private final Object2IntMap<ResourceLocation> shaders = new Object2IntRBTreeMap((a, b) -> {
        int compare = a.getNamespace().compareTo(b.getNamespace());
        if (compare == 0) {
            return a.getPath().compareTo(b.getPath());
        }
        return compare;
    });
    private final ImString programFilterText;
    private Pattern programFilter;
    private SelectedProgram selectedProgram;
    private int selectedTab;
    private final ImString addDefinitionText;
    private final Set<String> removedDefinitions;

    public ShaderInspector() {
        this.codeEditor = new CodeEditor(TITLE, null);
        this.codeEditor.getEditor().setLanguageDefinition(VeilLanguageDefinitions.glsl());
        this.shaderInfoVisible = new ImBoolean(false);
        this.programFilterText = new ImString(128);
        this.programFilter = null;
        this.selectedProgram = null;
        this.selectedTab = 0;
        this.addDefinitionText = new ImString(128);
        this.removedDefinitions = new HashSet<String>(1);
    }

    private void setSelectedProgram(@Nullable ResourceLocation name) {
        if (this.selectedProgram != null) {
            this.selectedProgram.free();
        }
        if (name != null && this.shaders.containsKey((Object)name)) {
            int program = this.shaders.getInt((Object)name);
            if (GL40C.glIsProgram((int)program)) {
                this.selectedProgram = SelectedProgram.create(name, program);
                return;
            }
            Veil.LOGGER.error("Compiled shader does not exist for program: {}", (Object)name);
        }
        this.selectedProgram = null;
    }

    private void setEditShaderSource(int shader) {
        this.codeEditor.show(null, GL40C.glGetShaderSource((int)shader));
    }

    private void reloadShaders() {
        if (this.selectedProgram != null) {
            this.selectedProgram.update();
        }
        this.shaders.clear();
        TabSource.values()[this.selectedTab].addShaders((arg_0, arg_1) -> this.shaders.put(arg_0, arg_1));
        if (this.isShaderInvalid() || this.selectedProgram != null && !this.shaders.containsKey((Object)this.selectedProgram.name)) {
            this.setSelectedProgram(null);
        }
    }

    private boolean isShaderInvalid() {
        return this.selectedProgram == null || this.selectedProgram.isShaderInvalid();
    }

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    protected void renderComponents() {
        this.codeEditor.getEditor().setReadOnly(true);
        this.removedDefinitions.clear();
        ImGui.beginChild((String)"##shader_programs", (float)(ImGui.getContentRegionAvailX() * 2.0f / 3.0f), (float)0.0f);
        VeilImGuiUtil.component((FormattedText)SHADER_PROGRAMS);
        TabSource[] sources = TabSource.values();
        if (ImGui.beginTabBar((String)"##controls")) {
            if (ImGui.tabItemButton((String)REFRESH.getString())) {
                this.reloadShaders();
            }
            for (TabSource source : sources) {
                ImGui.beginDisabled((!source.active.getAsBoolean() ? 1 : 0) != 0);
                if (ImGui.beginTabItem((String)source.displayName.getString())) {
                    if (this.selectedTab != source.ordinal()) {
                        this.selectedTab = source.ordinal();
                        this.setSelectedProgram(null);
                        this.reloadShaders();
                    }
                    ImGui.endTabItem();
                }
                ImGui.endDisabled();
            }
            ImGui.endTabBar();
        }
        while (!sources[this.selectedTab].active.getAsBoolean() && this.selectedTab > 0) {
            --this.selectedTab;
            this.setSelectedProgram(null);
            this.reloadShaders();
        }
        ImGui.setNextItemWidth((float)ImGui.getContentRegionAvailX());
        if (ImGui.inputTextWithHint((String)"##search", (String)SEARCH.getString(), (ImString)this.programFilterText)) {
            String regex = this.programFilterText.get();
            this.programFilter = null;
            if (!regex.isBlank()) {
                try {
                    this.programFilter = Pattern.compile(regex);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }
        if (ImGui.beginListBox((String)"##programs", (float)ImGui.getContentRegionAvailX(), (float)-1.4E-45f)) {
            for (Object2IntMap.Entry entry : this.shaders.object2IntEntrySet()) {
                boolean selected;
                ResourceLocation name = (ResourceLocation)entry.getKey();
                boolean bl = selected = this.selectedProgram != null && name.equals((Object)this.selectedProgram.name);
                if (this.programFilter != null && !this.programFilter.matcher(name.toString()).find()) {
                    if (!selected) continue;
                    this.setSelectedProgram(null);
                    continue;
                }
                if (ImGui.selectable((String)("##" + name.toString()), (boolean)selected)) {
                    this.setSelectedProgram(name);
                }
                ImGui.sameLine();
                VeilImGuiUtil.resourceLocation(name);
                ImGui.pushStyleVar((int)14, (float)0.0f, (float)ImGui.getStyle().getItemSpacingY());
                ImGui.sameLine();
                ImGui.text((String)(" (" + entry.getIntValue() + ")"));
                ImGui.popStyleVar();
            }
            ImGui.endListBox();
        }
        ImGui.endChild();
        ShaderPreDefinitions definitions = VeilRenderSystem.renderer().getShaderDefinitions();
        ImGui.sameLine();
        if (ImGui.beginChild((String)"##panel", (float)0.0f, (float)ImGui.getContentRegionAvailY())) {
            if (ImGui.beginChild((String)"##open_source", (float)0.0f, (float)(ImGui.getContentRegionAvailY() / 2.0f))) {
                VeilImGuiUtil.component((FormattedText)OPEN_SOURCE);
                this.openShaderButton(35632);
                this.openShaderButton(35633);
                this.openShaderButton(37305);
                this.openShaderButton(36313);
                this.openShaderButton(36488);
                this.openShaderButton(36487);
                ImGui.beginDisabled((boolean)this.shaderInfoVisible.get());
                if (ImGui.button((String)OPEN_SHADER_INFO.getString())) {
                    this.shaderInfoVisible.set(true);
                }
                ImGui.endDisabled();
            }
            ImGui.endChild();
            if (ImGui.beginChild((String)"##shader_definitions", (float)0.0f, (float)ImGui.getContentRegionAvailY())) {
                VeilImGuiUtil.component((FormattedText)SHADER_DEFINITIONS);
                ImGui.setNextItemWidth((float)ImGui.getContentRegionAvailX());
                if (ImGui.inputTextWithHint((String)"##add_definition", (String)SHADER_DEFINITIONS_HINT.getString(), (ImString)this.addDefinitionText, (int)32)) {
                    String[] parts = this.addDefinitionText.get().split("=", 2);
                    definitions.set(parts[0].trim(), parts.length > 1 ? parts[1].trim() : null);
                    this.addDefinitionText.clear();
                }
                if (ImGui.beginListBox((String)"##definitions", (float)-1.4E-45f, (float)ImGui.getContentRegionAvailY())) {
                    for (Map.Entry<String, String> entry : definitions.getDefinitions().entrySet()) {
                        String name = entry.getKey();
                        String value = entry.getValue();
                        ImGui.pushID((String)name);
                        ImGui.text((String)value);
                        float size = ImGui.getTextLineHeightWithSpacing();
                        ImGui.sameLine();
                        ImGui.dummy((float)(ImGui.getContentRegionAvailX() - ImGui.getStyle().getCellPaddingX() * 2.0f - size), (float)0.0f);
                        ImGui.sameLine();
                        if (ImGui.button((String)"X", (float)size, (float)size)) {
                            this.removedDefinitions.add(name);
                        }
                        ImGui.popID();
                    }
                    ImGui.endListBox();
                }
            }
            ImGui.endChild();
        }
        ImGui.endChild();
        for (String name : this.removedDefinitions) {
            definitions.remove(name);
        }
    }

    @Override
    public void render() {
        ImGui.setNextWindowSizeConstraints((float)600.0f, (float)400.0f, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
        super.render();
        this.codeEditor.renderWindow();
        if (this.shaderInfoVisible.get()) {
            ImGui.setNextWindowSizeConstraints((float)500.0f, (float)600.0f, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
            if (ImGui.begin((String)SHADER_INFO_WINDOW.getString(), (ImBoolean)this.shaderInfoVisible, (int)256)) {
                List<Map.Entry> sorted;
                ShaderUniformCache uniforms;
                boolean invalid = this.isShaderInvalid();
                ImGui.beginDisabled((boolean)invalid);
                int program = invalid ? 0 : this.selectedProgram.programId;
                ShaderUniformCache shaderUniformCache = uniforms = this.selectedProgram != null ? this.selectedProgram.uniforms : null;
                if (ImGui.collapsingHeader((String)SAMPLERS.getString(), (int)32) && !invalid) {
                    ImGui.indent();
                    for (Map.Entry<String, ShaderUniformCache.Uniform> entry2 : uniforms.getSamplers().entrySet()) {
                        ImGui.selectable((String)(entry2.getKey() + ": " + GL40C.glGetUniformi((int)program, (int)entry2.getValue().location())));
                    }
                    ImGui.unindent();
                }
                if (ImGui.collapsingHeader((String)UNIFORMS.getString(), (int)32) && !invalid) {
                    ImGui.indent();
                    sorted = uniforms.getUniforms().entrySet().stream().filter(entry -> !uniforms.hasSampler((String)entry.getKey())).sorted(Comparator.comparingInt(entry -> ((ShaderUniformCache.Uniform)entry.getValue()).location())).toList();
                    for (Map.Entry entry3 : sorted) {
                        String name = (String)entry3.getKey();
                        ShaderUniformCache.Uniform uniform = (ShaderUniformCache.Uniform)entry3.getValue();
                        ImGui.selectable((String)this.formatUniform(name, program, uniform));
                    }
                    ImGui.unindent();
                }
                if (ImGui.collapsingHeader((String)UNIFORM_BLOCKS.getString(), (int)32) && !invalid) {
                    ImGui.indent();
                    sorted = uniforms.getUniformBlocks().entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ShaderUniformCache.UniformBlock)entry.getValue()).index())).toList();
                    for (Map.Entry entry3 : sorted) {
                        String blockName = (String)entry3.getKey();
                        if (!ImGui.collapsingHeader((String)blockName)) continue;
                        ImGui.indent();
                        ShaderUniformCache.UniformBlock block = (ShaderUniformCache.UniformBlock)entry3.getValue();
                        int buffer = GL40C.glGetIntegeri((int)35368, (int)GL40C.glGetActiveUniformBlocki((int)program, (int)block.index(), (int)35391));
                        RenderSystem.glBindBuffer((int)36662, (int)buffer);
                        ByteBuffer data = GL40C.glMapBuffer((int)36662, (int)35000, (long)block.size(), null);
                        for (ShaderUniformCache.Uniform field : block.fields()) {
                            String name = field.name().startsWith(blockName) ? field.name().substring(blockName.length() + 1) : field.name();
                            ImGui.selectable((String)(data != null ? this.formatBuffer(name, data, field, 0) : name));
                        }
                        GL40C.glUnmapBuffer((int)36662);
                        ImGui.unindent();
                    }
                    ImGui.unindent();
                }
                ImGui.beginDisabled((!VeilRenderSystem.shaderStorageBufferSupported() ? 1 : 0) != 0);
                if (ImGui.collapsingHeader((String)STORAGE_BLOCKS.getString(), (int)32) && !invalid) {
                    ImGui.indent();
                    sorted = uniforms.getStorageBlocks().entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ShaderUniformCache.StorageBlock)entry.getValue()).index())).toList();
                    try (MemoryStack memoryStack = MemoryStack.stackPush();){
                        IntBuffer properties = memoryStack.ints(37634);
                        IntBuffer buffer = memoryStack.mallocInt(1);
                        for (Map.Entry entry4 : sorted) {
                            String blockName = (String)entry4.getKey();
                            if (!ImGui.collapsingHeader((String)blockName)) continue;
                            ImGui.indent();
                            ShaderUniformCache.StorageBlock block = (ShaderUniformCache.StorageBlock)entry4.getValue();
                            ARBProgramInterfaceQuery.glGetProgramResourceiv((int)program, (int)37606, (int)block.index(), (IntBuffer)properties, null, (IntBuffer)buffer);
                            RenderSystem.glBindBuffer((int)36662, (int)buffer.get(0));
                            int size = block.array() ? GL40C.glGetBufferParameteri((int)36662, (int)34660) : block.size();
                            final ByteBuffer data = GL40C.glMapBuffer((int)36662, (int)35000, (long)size, null);
                            ShaderUniformCache.Uniform[] fields = block.fields();
                            for (int i = 0; i < fields.length; ++i) {
                                String name;
                                final ShaderUniformCache.Uniform field = fields[i];
                                String string = name = field.name().startsWith(blockName) ? field.name().substring(blockName.length() + 1) : field.name();
                                if (block.array() && i >= fields.length - 1 && data != null) {
                                    ImGuiListClipper.forEach((int)((data.limit() - field.offset()) / block.arrayStride()), (int)((int)ImGui.getTextLineHeightWithSpacing()), (ImListClipperCallback)new ImListClipperCallback(){

                                        public void accept(int index) {
                                            ImGui.selectable((String)ShaderInspector.this.formatBuffer(name, data, field, index));
                                        }
                                    });
                                    continue;
                                }
                                ImGui.selectable((String)(data != null ? this.formatBuffer(name, data, field, 0) : name));
                            }
                            GL40C.glUnmapBuffer((int)36662);
                            ImGui.unindent();
                        }
                    }
                    ImGui.unindent();
                }
                ImGui.endDisabled();
                ImGui.endDisabled();
            }
            ImGui.end();
        }
    }

    private String formatUniform(String name, int program, ShaderUniformCache.Uniform uniform) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            String string = switch (uniform.type()) {
                case 5126 -> this.formatUniformFloats(stack, "float " + name, program, uniform.location(), 1, 1);
                case 35664 -> this.formatUniformFloats(stack, "vec2 " + name, program, uniform.location(), 2, 1);
                case 35665 -> this.formatUniformFloats(stack, "vec3 " + name, program, uniform.location(), 3, 1);
                case 35666 -> this.formatUniformFloats(stack, "vec4 " + name, program, uniform.location(), 4, 1);
                case 5130 -> this.formatUniformDoubles(stack, "double " + name, program, uniform.location(), 1, 1);
                case 36860 -> this.formatUniformDoubles(stack, "dvec2 " + name, program, uniform.location(), 2, 1);
                case 36861 -> this.formatUniformDoubles(stack, "dvec3 " + name, program, uniform.location(), 3, 1);
                case 36862 -> this.formatUniformDoubles(stack, "dvec4 " + name, program, uniform.location(), 4, 1);
                case 5124 -> this.formatUniformInts(stack, "int " + name, program, uniform.location(), 1);
                case 35667 -> this.formatUniformInts(stack, "ivec2 " + name, program, uniform.location(), 2);
                case 35668 -> this.formatUniformInts(stack, "ivec3 " + name, program, uniform.location(), 3);
                case 35669 -> this.formatUniformInts(stack, "ivec4 " + name, program, uniform.location(), 4);
                case 5125 -> this.formatUniformUInts(stack, "uint " + name, program, uniform.location(), 1);
                case 36294 -> this.formatUniformUInts(stack, "uvec2 " + name, program, uniform.location(), 2);
                case 36295 -> this.formatUniformUInts(stack, "uvec3 " + name, program, uniform.location(), 3);
                case 36296 -> this.formatUniformUInts(stack, "uvec4 " + name, program, uniform.location(), 4);
                case 35674 -> this.formatUniformFloats(stack, "mat2 " + name, program, uniform.location(), 2, 2);
                case 35675 -> this.formatUniformFloats(stack, "mat3 " + name, program, uniform.location(), 3, 3);
                case 35676 -> this.formatUniformFloats(stack, "mat4 " + name, program, uniform.location(), 4, 4);
                case 35685 -> this.formatUniformFloats(stack, "mat2x3 " + name, program, uniform.location(), 2, 3);
                case 35686 -> this.formatUniformFloats(stack, "mat2x4 " + name, program, uniform.location(), 2, 4);
                case 35687 -> this.formatUniformFloats(stack, "mat3x2 " + name, program, uniform.location(), 3, 2);
                case 35688 -> this.formatUniformFloats(stack, "mat3x4 " + name, program, uniform.location(), 3, 4);
                case 35689 -> this.formatUniformFloats(stack, "mat4x2 " + name, program, uniform.location(), 4, 2);
                case 35690 -> this.formatUniformFloats(stack, "mat4x3 " + name, program, uniform.location(), 4, 3);
                case 36678 -> this.formatUniformDoubles(stack, "dmat2 " + name, program, uniform.location(), 2, 2);
                case 36679 -> this.formatUniformDoubles(stack, "dmat3 " + name, program, uniform.location(), 3, 3);
                case 36680 -> this.formatUniformDoubles(stack, "dmat4 " + name, program, uniform.location(), 4, 4);
                case 36681 -> this.formatUniformDoubles(stack, "dmat2x3 " + name, program, uniform.location(), 2, 3);
                case 36682 -> this.formatUniformDoubles(stack, "dmat2x4 " + name, program, uniform.location(), 2, 4);
                case 36683 -> this.formatUniformDoubles(stack, "dmat3x2 " + name, program, uniform.location(), 3, 2);
                case 36684 -> this.formatUniformDoubles(stack, "dmat3x4 " + name, program, uniform.location(), 3, 4);
                case 36685 -> this.formatUniformDoubles(stack, "dmat4x2 " + name, program, uniform.location(), 4, 2);
                case 36686 -> this.formatUniformDoubles(stack, "dmat4x3 " + name, program, uniform.location(), 4, 3);
                default -> name;
            };
            return string;
        }
    }

    private String formatBuffer(String name, ByteBuffer buffer, ShaderUniformCache.Uniform uniform, int offset) {
        return switch (uniform.type()) {
            case 5126 -> this.formatFloats(uniform.offset() + offset + ": float " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 1, 1);
            case 35664 -> this.formatFloats(uniform.offset() + offset + ": vec2 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 2, 1);
            case 35665 -> this.formatFloats(uniform.offset() + offset + ": vec3 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 3, 1);
            case 35666 -> this.formatFloats(uniform.offset() + offset + ": vec4 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 4, 1);
            case 5130 -> this.formatDoubles(uniform.offset() + offset + ": double " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 1, 1);
            case 36860 -> this.formatDoubles(uniform.offset() + offset + ": dvec2 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 2, 1);
            case 36861 -> this.formatDoubles(uniform.offset() + offset + ": dvec3 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 3, 1);
            case 36862 -> this.formatDoubles(uniform.offset() + offset + ": dvec4 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 4, 1);
            case 5124 -> this.formatInts(uniform.offset() + offset + ": int " + name, i -> buffer.getInt(uniform.offset() + offset + (i << 2)), 1);
            case 35667 -> this.formatInts(uniform.offset() + offset + ": ivec2 " + name, i -> buffer.getInt(uniform.offset() + offset + (i << 2)), 2);
            case 35668 -> this.formatInts(uniform.offset() + offset + ": ivec3 " + name, i -> buffer.getInt(uniform.offset() + offset + (i << 2)), 3);
            case 35669 -> this.formatInts(uniform.offset() + offset + ": ivec4 " + name, i -> buffer.getInt(uniform.offset() + offset + (i << 2)), 4);
            case 5125 -> this.formatUInts(uniform.offset() + offset + ": uint " + name, i -> buffer.getInt(uniform.offset() + offset + (i << 2)), 1);
            case 36294 -> this.formatUInts(uniform.offset() + offset + ": uvec2 " + name, i -> buffer.getInt(uniform.offset() + offset + (i << 2)), 2);
            case 36295 -> this.formatUInts(uniform.offset() + offset + ": uvec3 " + name, i -> buffer.getInt(uniform.offset() + offset + (i << 2)), 3);
            case 36296 -> this.formatUInts(uniform.offset() + offset + ": uvec4 " + name, i -> buffer.getInt(uniform.offset() + offset + (i << 2)), 4);
            case 35674 -> this.formatFloats(uniform.offset() + offset + ": mat2 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 2, 2);
            case 35675 -> this.formatFloats(uniform.offset() + offset + ": mat3 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 3, 3);
            case 35676 -> this.formatFloats(uniform.offset() + offset + ": mat4 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 4, 4);
            case 35685 -> this.formatFloats(uniform.offset() + offset + ": mat2x3 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 2, 3);
            case 35686 -> this.formatFloats(uniform.offset() + offset + ": mat2x4 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 2, 4);
            case 35687 -> this.formatFloats(uniform.offset() + offset + ": mat3x2 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 3, 2);
            case 35688 -> this.formatFloats(uniform.offset() + offset + ": mat3x4 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 3, 4);
            case 35689 -> this.formatFloats(uniform.offset() + offset + ": mat4x2 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 4, 2);
            case 35690 -> this.formatFloats(uniform.offset() + offset + ": mat4x3 " + name, i -> Float.valueOf(buffer.getFloat(uniform.offset() + offset + (i << 2))), 4, 3);
            case 36678 -> this.formatDoubles(uniform.offset() + offset + ": dmat2 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 2, 2);
            case 36679 -> this.formatDoubles(uniform.offset() + offset + ": dmat3 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 3, 3);
            case 36680 -> this.formatDoubles(uniform.offset() + offset + ": dmat4 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 4, 4);
            case 36681 -> this.formatDoubles(uniform.offset() + offset + ": dmat2x3 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 2, 3);
            case 36682 -> this.formatDoubles(uniform.offset() + offset + ": dmat2x4 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 2, 4);
            case 36683 -> this.formatDoubles(uniform.offset() + offset + ": dmat3x2 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 3, 2);
            case 36684 -> this.formatDoubles(uniform.offset() + offset + ": dmat3x4 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 3, 4);
            case 36685 -> this.formatDoubles(uniform.offset() + offset + ": dmat4x2 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 4, 2);
            case 36686 -> this.formatDoubles(uniform.offset() + offset + ": dmat4x3 " + name, i -> buffer.getDouble(uniform.offset() + offset + (i << 3)), 4, 3);
            default -> name;
        };
    }

    private String formatUniformFloats(MemoryStack stack, String key, int program, int location, int cols, int rows) {
        FloatBuffer values = stack.mallocFloat(rows * cols);
        GL40C.glGetUniformfv((int)program, (int)location, (FloatBuffer)values);
        return this.formatFloats(key, values::get, cols, rows);
    }

    private String formatUniformDoubles(MemoryStack stack, String key, int program, int location, int cols, int rows) {
        DoubleBuffer values = stack.mallocDouble(rows * cols);
        GL40C.glGetUniformdv((int)program, (int)location, (DoubleBuffer)values);
        return this.formatDoubles(key, values::get, cols, rows);
    }

    private String formatUniformInts(MemoryStack stack, String key, int program, int location, int cols) {
        IntBuffer values = stack.mallocInt(cols);
        GL40C.glGetUniformiv((int)program, (int)location, (IntBuffer)values);
        return this.formatInts(key, values::get, cols);
    }

    private String formatUniformUInts(MemoryStack stack, String key, int program, int location, int cols) {
        IntBuffer values = stack.mallocInt(cols);
        GL40C.glGetUniformuiv((int)program, (int)location, (IntBuffer)values);
        return this.formatUInts(key, values::get, cols);
    }

    private String formatFloats(String key, Function<Integer, Float> deserializer, int cols, int rows) {
        int col;
        int row;
        StringBuilder matrix = new StringBuilder(key + ":" + (rows > 1 ? (char)'\n' : ' '));
        int[] colWidths = new int[cols];
        for (row = 0; row < rows; ++row) {
            for (col = 0; col < cols; ++col) {
                int size = "%+.4f".formatted(deserializer.apply(col * rows + row)).length();
                if (size <= colWidths[col]) continue;
                colWidths[col] = size;
            }
        }
        for (row = 0; row < rows; ++row) {
            matrix.append('[');
            for (col = 0; col < cols; ++col) {
                String value = ("%+" + colWidths[col] + ".4f").formatted(deserializer.apply(col * rows + row));
                matrix.append(value).append(", ");
            }
            matrix.replace(matrix.length() - 2, matrix.length(), "]\n");
        }
        matrix.delete(matrix.length() - 1, matrix.length());
        return matrix.toString();
    }

    private String formatDoubles(String key, Function<Integer, Double> deserializer, int cols, int rows) {
        int col;
        int row;
        StringBuilder matrix = new StringBuilder(key + ":" + (rows > 1 ? (char)'\n' : ' '));
        int[] colWidths = new int[cols];
        for (row = 0; row < rows; ++row) {
            for (col = 0; col < cols; ++col) {
                int size = "%+.4f".formatted(deserializer.apply(col * rows + row)).length();
                if (size <= colWidths[col]) continue;
                colWidths[col] = size;
            }
        }
        for (row = 0; row < rows; ++row) {
            matrix.append('[');
            for (col = 0; col < cols; ++col) {
                String value = ("%+" + colWidths[col] + ".4f").formatted(deserializer.apply(col * rows + row));
                matrix.append(value).append(", ");
            }
            matrix.replace(matrix.length() - 2, matrix.length(), "]\n");
        }
        matrix.delete(matrix.length() - 1, matrix.length());
        return matrix.toString();
    }

    private String formatInts(String key, Function<Integer, Integer> deserializer, int cols) {
        int col;
        StringBuilder matrix = new StringBuilder(key + ": [");
        int[] colWidths = new int[cols];
        for (col = 0; col < cols; ++col) {
            int size = "%+d".formatted(deserializer.apply(col)).length();
            if (size <= colWidths[col]) continue;
            colWidths[col] = size;
        }
        for (col = 0; col < cols; ++col) {
            String value = ("%+" + colWidths[col] + "d").formatted(deserializer.apply(col));
            matrix.append(value).append(", ");
        }
        matrix.replace(matrix.length() - 2, matrix.length(), "]");
        return matrix.toString();
    }

    private String formatUInts(String key, Function<Integer, Integer> deserializer, int cols) {
        int col;
        StringBuilder matrix = new StringBuilder(key + ": [");
        int[] colWidths = new int[cols];
        for (col = 0; col < cols; ++col) {
            int size = "%+d".formatted(Integer.toUnsignedLong(deserializer.apply(col))).length();
            if (size <= colWidths[col]) continue;
            colWidths[col] = size;
        }
        for (col = 0; col < cols; ++col) {
            String value = ("%+" + colWidths[col] + "d").formatted(Integer.toUnsignedLong(deserializer.apply(col)));
            matrix.append(value).append(", ");
        }
        matrix.replace(matrix.length() - 2, matrix.length(), "]");
        return matrix.toString();
    }

    private void openShaderButton(int type) {
        boolean disabled = this.isShaderInvalid() || !this.selectedProgram.shaders.containsKey(type);
        ImGui.beginDisabled((boolean)disabled);
        if (disabled) {
            ImGui.pushStyleColor((int)21, (int)ImGui.getColorU32((int)7));
        }
        if (ImGui.button((String)DeviceInfoViewer.getShaderName(type).getString())) {
            this.setEditShaderSource(this.selectedProgram.shaders.get(type));
        }
        if (disabled) {
            ImGui.popStyleColor();
        }
        ImGui.endDisabled();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.reloadShaders();
    }

    @Override
    public void onHide() {
        super.onHide();
        this.shaders.clear();
    }

    @Override
    public void free() {
        super.free();
        this.codeEditor.free();
        if (this.selectedProgram != null) {
            this.selectedProgram.free();
            this.selectedProgram = null;
        }
    }

    public void onResourceManagerReload(@NotNull ResourceManager resourceManager) {
        if (this.isOpen()) {
            this.reloadShaders();
        }
    }

    private record SelectedProgram(ResourceLocation name, int programId, Int2IntMap shaders, ShaderUniformCache uniforms, Int2ObjectMap<ByteBuffer> data) implements NativeResource
    {
        public static SelectedProgram create(ResourceLocation name, int program) {
            int[] attachedShaders = new int[GL40C.glGetProgrami((int)program, (int)35717)];
            GL40C.glGetAttachedShaders((int)program, null, (int[])attachedShaders);
            Int2IntArrayMap shaders = new Int2IntArrayMap(attachedShaders.length);
            for (int shader : attachedShaders) {
                shaders.put(GL40C.glGetShaderi((int)shader, (int)35663), shader);
            }
            ShaderUniformCache cache = new ShaderUniformCache(() -> program);
            Int2ObjectArrayMap data = new Int2ObjectArrayMap(cache.getUniformBlocks().size());
            return new SelectedProgram(name, program, Int2IntMaps.unmodifiable((Int2IntMap)shaders), cache, (Int2ObjectMap<ByteBuffer>)data);
        }

        public boolean isShaderInvalid() {
            return this.programId == 0 || !GL40C.glIsProgram((int)this.programId);
        }

        public void update() {
            this.uniforms.clear();
        }

        public void free() {
            this.uniforms.clear();
        }
    }

    private static enum TabSource {
        VANILLA((Component)Component.translatable((String)"inspector.veil.shader.source.vanilla")){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                DebugGameRendererAccessor accessor = (DebugGameRendererAccessor)Minecraft.getInstance().gameRenderer;
                Map<String, ShaderInstance> shaders = accessor.getShaders();
                for (ShaderInstance shader : shaders.values()) {
                    String name = shader.getName().isBlank() ? Integer.toString(shader.getId()) : shader.getName();
                    registry.accept(ResourceLocation.parse((String)name), shader.getId());
                }
                ShaderInstance blitShader = accessor.getBlitShader();
                registry.accept(ResourceLocation.parse((String)blitShader.getName()), blitShader.getId());
            }
        }
        ,
        VANILLA_POST((Component)Component.translatable((String)"inspector.veil.shader.source.vanilla_post")){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                DebugLevelRendererAccessor levelRendererAccessor = (DebugLevelRendererAccessor)Minecraft.getInstance().levelRenderer;
                this.addChainPasses(registry, levelRendererAccessor.getEntityEffect());
                this.addChainPasses(registry, levelRendererAccessor.getTransparencyChain());
                DebugGameRendererAccessor gameRendererAccessor = (DebugGameRendererAccessor)Minecraft.getInstance().gameRenderer;
                this.addChainPasses(registry, gameRendererAccessor.getPostEffect());
            }

            private void addChainPasses(ObjIntConsumer<ResourceLocation> registry, @Nullable PostChain chain) {
                if (chain == null) {
                    return;
                }
                List<PostPass> passes = ((DebugPostChainAccessor)chain).getPasses();
                for (PostPass pass : passes) {
                    EffectInstance effect = pass.getEffect();
                    registry.accept(ResourceLocation.parse((String)effect.getName()), effect.getId());
                }
            }
        }
        ,
        VEIL((Component)Component.translatable((String)"inspector.veil.shader.source.veil")){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                Map<ResourceLocation, ShaderProgram> shaders = VeilRenderSystem.renderer().getShaderManager().getShaders();
                for (ShaderProgram shader : shaders.values()) {
                    registry.accept(shader.getName(), shader.getProgram());
                }
                VeilImGuiImpl.get().addImguiShaders(registry);
            }
        }
        ,
        IRIS((Component)Component.translatable((String)"inspector.veil.shader.source.iris"), () -> IrisCompat.INSTANCE != null){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                for (ShaderInstance shader : IrisCompat.INSTANCE.getLoadedShaders()) {
                    String name = shader.getName().isBlank() ? Integer.toString(shader.getId()) : shader.getName();
                    registry.accept(ResourceLocation.parse((String)name), shader.getId());
                }
            }
        }
        ,
        SODIUM((Component)Component.translatable((String)"inspector.veil.shader.source.sodium"), () -> SodiumCompat.INSTANCE != null){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                for (Object2IntMap.Entry entry : SodiumCompat.INSTANCE.getLoadedShaders().object2IntEntrySet()) {
                    registry.accept((ResourceLocation)entry.getKey(), entry.getIntValue());
                }
            }
        }
        ,
        OTHER((Component)Component.translatable((String)"inspector.veil.shader.source.unknown")){

            @Override
            public void addShaders(ObjIntConsumer<ResourceLocation> registry) {
                IntOpenHashSet programs = new IntOpenHashSet();
                for (int i = 1; i < 10000; ++i) {
                    if (!GL40C.glIsProgram((int)i)) continue;
                    programs.add(i);
                }
                for (TabSource value : TabSource.values()) {
                    if (value == this || !value.active.getAsBoolean()) continue;
                    value.addShaders((arg_0, arg_1) -> 6.lambda$addShaders$0((IntSet)programs, arg_0, arg_1));
                }
                IntIterator intIterator = programs.iterator();
                while (intIterator.hasNext()) {
                    int program = (Integer)intIterator.next();
                    registry.accept(ResourceLocation.fromNamespaceAndPath((String)"unknown", (String)Integer.toString(program)), program);
                }
            }

            private static /* synthetic */ void lambda$addShaders$0(IntSet programs, ResourceLocation name, int id) {
                programs.remove(id);
            }
        };

        private final Component displayName;
        private final BooleanSupplier active;

        private TabSource(Component displayName) {
            this(displayName, () -> true);
        }

        private TabSource(Component displayName, BooleanSupplier active) {
            this.displayName = displayName;
            this.active = active;
        }

        public abstract void addShaders(ObjIntConsumer<ResourceLocation> var1);
    }
}

