/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.imgui;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.impl.client.imgui.AdvancedFboImGuiAreaImpl;
import foundry.veil.impl.client.imgui.ImGuiStateStack;
import foundry.veil.impl.client.imgui.InactiveVeilImGuiImpl;
import foundry.veil.impl.client.imgui.VeilImGui;
import foundry.veil.impl.client.imgui.VeilImGuiImplGlfw;
import foundry.veil.impl.client.imgui.VeilImGuiStylesheet;
import imgui.ImGui;
import imgui.extension.implot.ImPlot;
import imgui.extension.implot.ImPlotContext;
import imgui.gl3.ImGuiImplGl3;
import imgui.internal.ImGuiContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ObjIntConsumer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class VeilImGuiImpl
implements VeilImGui,
NativeResource {
    private static final MethodHandle DATA_GETTER;
    private static final MethodHandle SHADER_GETTER;
    private static VeilImGui instance;
    private final VeilImGuiImplGlfw implGlfw = new VeilImGuiImplGlfw(this);
    private final ImGuiImplGl3 implGl3 = new ImGuiImplGl3();
    private final ImGuiContext imGuiContext;
    private final ImPlotContext imPlotContext;
    private final AtomicBoolean active;

    private VeilImGuiImpl(long window) throws Throwable {
        ImGuiStateStack.push();
        ImGuiContext imGuiContext = null;
        ImPlotContext imPlotContext = null;
        try {
            imGuiContext = ImGui.createContext();
            imPlotContext = ImPlot.createContext();
            this.active = new AtomicBoolean();
            this.implGl3.init("#version 410 core");
            this.implGlfw.init(window, true);
            VeilImGuiStylesheet.initStyles();
        }
        catch (Throwable t) {
            this.implGlfw.shutdown();
            this.implGl3.destroyDeviceObjects();
            if (imGuiContext != null) {
                ImGui.destroyContext((ImGuiContext)imGuiContext);
            }
            if (imPlotContext != null) {
                ImPlot.destroyContext((ImPlotContext)imPlotContext);
            }
            throw t;
        }
        finally {
            ImGuiStateStack.forcePop();
        }
        this.imGuiContext = imGuiContext;
        this.imPlotContext = imPlotContext;
    }

    @Override
    public void start() {
        ImGuiStateStack.push();
        ImGui.setCurrentContext((ImGuiContext)this.imGuiContext);
        ImPlot.setCurrentContext((ImPlotContext)this.imPlotContext);
        if (ImGui.getCurrentContext().isNotValidPtr()) {
            throw new IllegalStateException("ImGui Context is not valid");
        }
        RenderSystem.assertOnRenderThread();
    }

    @Override
    public void stop() {
        RenderSystem.assertOnRenderThread();
        ImGuiStateStack.pop();
    }

    @Override
    public void beginFrame() {
        try {
            this.start();
            if (this.active.get()) {
                Veil.LOGGER.error("ImGui failed to render previous frame, disposing");
                ImGui.endFrame();
            }
            this.active.set(true);
            this.implGl3.newFrame();
            this.implGlfw.newFrame();
            ImGui.newFrame();
            AdvancedFboImGuiAreaImpl.begin();
            VeilRenderSystem.renderer().getEditorManager().render();
        }
        finally {
            this.stop();
        }
    }

    @Override
    public void endFrame() {
        AdvancedFboImGuiAreaImpl.end();
        try {
            if (!this.active.get()) {
                Veil.LOGGER.error("ImGui state de-synced");
                return;
            }
            this.start();
            this.active.set(false);
            VeilRenderSystem.renderer().getEditorManager().renderLast();
            ImGui.render();
            this.implGl3.renderDrawData(ImGui.getDrawData());
            if (ImGui.getIO().hasConfigFlags(1024)) {
                long backupWindowPtr = GLFW.glfwGetCurrentContext();
                ImGui.updatePlatformWindows();
                ImGui.renderPlatformWindowsDefault();
                GLFW.glfwMakeContextCurrent((long)backupWindowPtr);
            }
        }
        finally {
            ImGuiStateStack.forcePop();
        }
    }

    @Override
    public void toggle() {
        VeilRenderSystem.renderer().getEditorManager().toggle();
    }

    @Override
    public void updateFonts() {
        this.implGl3.destroyFontsTexture();
        if (!this.implGl3.createFontsTexture()) {
            throw new IllegalStateException("Failed to update font texture");
        }
    }

    @Override
    public void addImguiShaders(ObjIntConsumer<ResourceLocation> registry) {
        if (DATA_GETTER != null && SHADER_GETTER != null) {
            try {
                int handle = SHADER_GETTER.invoke(DATA_GETTER.invoke(this.implGl3));
                registry.accept(ResourceLocation.fromNamespaceAndPath((String)"imgui", (String)"blit"), handle);
            }
            catch (Throwable t) {
                Veil.LOGGER.warn("Failed to add ImGui shader", t);
            }
        }
    }

    public void free() {
        try {
            this.start();
            this.implGlfw.shutdown();
            this.implGl3.destroyDeviceObjects();
            ImGui.destroyContext((ImGuiContext)this.imGuiContext);
            ImPlot.destroyContext((ImPlotContext)this.imPlotContext);
        }
        finally {
            this.stop();
        }
    }

    public static void init(long window) {
        try {
            instance = Veil.IMGUI ? new VeilImGuiImpl(window) : new InactiveVeilImGuiImpl();
        }
        catch (Throwable t) {
            Veil.LOGGER.error("Failed to load ImGui, disabling", t);
            instance = new InactiveVeilImGuiImpl();
        }
    }

    public static void setImGuiPath() {
    }

    public static VeilImGui get() {
        return instance;
    }

    static {
        MethodHandle shaderGetter;
        MethodHandle dataGetter;
        try {
            Class<?> dataClass = Class.forName("imgui.gl3.ImGuiImplGl3$Data");
            MethodHandles.Lookup dataLookup = MethodHandles.privateLookupIn(ImGuiImplGl3.class, MethodHandles.lookup());
            dataGetter = dataLookup.findGetter(ImGuiImplGl3.class, "data", dataClass);
            MethodHandles.Lookup shaderLookup = MethodHandles.privateLookupIn(dataClass, dataLookup);
            shaderGetter = shaderLookup.findGetter(dataClass, "shaderHandle", Integer.TYPE);
        }
        catch (Throwable t) {
            Veil.LOGGER.error("Failed to get ImGui shader handle: {}", (Object)t.getMessage());
            dataGetter = null;
            shaderGetter = null;
        }
        DATA_GETTER = dataGetter;
        SHADER_GETTER = shaderGetter;
        instance = new InactiveVeilImGuiImpl();
    }
}

