/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.framebuffer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.ext.VeilDebug;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.impl.client.render.framebuffer.AdvancedFboImpl;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBClearTexture;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryStack;

@ApiStatus.Internal
public class DSAAdvancedFboImpl
extends AdvancedFboImpl {
    public DSAAdvancedFboImpl(int width, int height, AdvancedFboAttachment[] colorAttachments, @Nullable AdvancedFboAttachment depthAttachment, @Nullable String debugLabel) {
        super(width, height, colorAttachments, depthAttachment, debugLabel);
    }

    @Override
    public void create() {
        int status;
        for (AdvancedFboAttachment attachment : this.colorAttachments) {
            attachment.create();
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.create();
        }
        this.id = ARBDirectStateAccess.glCreateFramebuffers();
        if (this.debugLabel != null) {
            VeilDebug.get().objectLabel(36160, this.id, "Advanced Fbo " + this.debugLabel);
        }
        for (int i = 0; i < this.colorAttachments.length; ++i) {
            this.colorAttachments[i].attach(this, i);
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.attach(this, 0);
        }
        if ((status = ARBDirectStateAccess.glCheckNamedFramebufferStatus((int)this.id, (int)36160)) != 36053) {
            Object error = ERRORS.containsKey(status) ? (String)ERRORS.get(status) : "0x" + Integer.toHexString(status).toUpperCase(Locale.ROOT);
            throw new IllegalStateException("Advanced FBO status did not return GL_FRAMEBUFFER_COMPLETE. " + (String)error);
        }
        this.currentDrawBuffers = this.drawBuffers;
        ARBDirectStateAccess.glNamedFramebufferDrawBuffers((int)this.id, (int[])this.drawBuffers);
    }

    @Override
    public void clear(float red, float green, float blue, float alpha, float depth, int clearMask, int ... buffers) {
        if (clearMask == 0) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            boolean clearTex = VeilRenderSystem.clearTextureSupported();
            if ((clearMask & 0x4000) != 0) {
                FloatBuffer color = stack.floats(red, green, blue, alpha);
                for (int buffer : buffers) {
                    int i = buffer - 36064;
                    if (i < 0 || i >= this.colorAttachments.length) continue;
                    AdvancedFboAttachment attachment = this.colorAttachments[i];
                    if (clearTex && attachment instanceof AdvancedFboTextureAttachment) {
                        AdvancedFboTextureAttachment texture = (AdvancedFboTextureAttachment)attachment;
                        ARBClearTexture.glClearTexImage((int)texture.getId(), (int)0, (int)6408, (int)5126, (FloatBuffer)color);
                        continue;
                    }
                    ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.id, (int)6144, (int)i, (FloatBuffer)color);
                }
            }
            if (this.depthAttachment != null) {
                AdvancedFboAttachment advancedFboAttachment;
                boolean hasStencil;
                boolean hasDepth = (clearMask & 0x100) != 0;
                boolean bl = hasStencil = this.hasStencil && (clearMask & 0x400) != 0;
                if (!hasDepth && !hasStencil) {
                    return;
                }
                if (this.hasStencil) {
                    if (hasDepth && hasStencil) {
                        AdvancedFboAttachment advancedFboAttachment2;
                        if (clearTex && (advancedFboAttachment2 = this.depthAttachment) instanceof AdvancedFboTextureAttachment) {
                            AdvancedFboTextureAttachment texture = (AdvancedFboTextureAttachment)advancedFboAttachment2;
                            ARBClearTexture.glClearTexImage((int)texture.getId(), (int)0, (int)34041, (int)36269, (ByteBuffer)null);
                        } else {
                            ARBDirectStateAccess.glClearNamedFramebufferfi((int)this.id, (int)34041, (int)0, (float)depth, (int)GL30C.glGetInteger((int)2961));
                        }
                    } else {
                        if (hasDepth) {
                            ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.id, (int)6145, (int)0, (FloatBuffer)stack.floats(depth));
                        }
                        if (hasStencil) {
                            ARBDirectStateAccess.glClearNamedFramebufferiv((int)this.id, (int)6146, (int)0, (IntBuffer)stack.ints(GL30C.glGetInteger((int)2961)));
                        }
                    }
                } else if (clearTex && (advancedFboAttachment = this.depthAttachment) instanceof AdvancedFboTextureAttachment) {
                    AdvancedFboTextureAttachment texture = (AdvancedFboTextureAttachment)advancedFboAttachment;
                    ARBClearTexture.glClearTexImage((int)texture.getId(), (int)0, (int)6402, (int)5126, (FloatBuffer)stack.floats(depth));
                } else {
                    ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.id, (int)6145, (int)0, (FloatBuffer)stack.floats(depth));
                }
            }
        }
        if (Minecraft.ON_OSX) {
            GL30C.glGetError();
        }
    }

    @Override
    public void resetDrawBuffers() {
        if (Arrays.mismatch(this.currentDrawBuffers, this.drawBuffers) >= 0) {
            this.currentDrawBuffers = this.drawBuffers;
            ARBDirectStateAccess.glNamedFramebufferDrawBuffers((int)this.id, (int[])this.drawBuffers);
        }
    }

    @Override
    public void drawBuffers(int ... buffers) {
        if (Arrays.mismatch(this.currentDrawBuffers, buffers) >= 0) {
            if (this.currentDrawBuffers.length != buffers.length) {
                this.currentDrawBuffers = Arrays.copyOf(buffers, buffers.length);
            } else {
                System.arraycopy(buffers, 0, this.currentDrawBuffers, 0, buffers.length);
            }
            ARBDirectStateAccess.glNamedFramebufferDrawBuffers((int)this.id, (int[])buffers);
        }
    }

    @Override
    public void resolveToFbo(int id, int width, int height, int mask, int filtering) {
        ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.id, (int)id, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)width, (int)height, (int)mask, (int)filtering);
    }

    @Override
    public void resolveToAdvancedFbo(AdvancedFbo target, int mask, int filtering) {
        ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.id, (int)target.getId(), (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)target.getWidth(), (int)target.getHeight(), (int)mask, (int)filtering);
    }

    @Override
    public void resolveToRenderTarget(RenderTarget target, int mask, int filtering) {
        ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.id, (int)target.frameBufferId, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)target.width, (int)target.height, (int)mask, (int)filtering);
    }
}

