/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.light;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.render.light.data.AreaLightData;
import foundry.veil.api.client.render.light.renderer.InstancedLightRenderer;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import foundry.veil.api.client.render.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AreaLightRenderer
extends InstancedLightRenderer<AreaLightData> {
    private static final ResourceLocation RENDER_TYPE = Veil.veilPath("light/area");

    public AreaLightRenderer() {
        super(90);
    }

    @Override
    protected MeshData createMesh() {
        BufferBuilder builder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION);
        LightTypeRenderer.createInvertedCube((VertexConsumer)builder);
        return builder.buildOrThrow();
    }

    @Override
    protected void setupBufferState(VertexArrayBuilder builder) {
        builder.setVertexAttribute(1, 2, 4, VertexArrayBuilder.DataType.FLOAT, false, 0);
        builder.setVertexAttribute(2, 2, 4, VertexArrayBuilder.DataType.FLOAT, false, 16);
        builder.setVertexAttribute(3, 2, 4, VertexArrayBuilder.DataType.FLOAT, false, 32);
        builder.setVertexAttribute(4, 2, 4, VertexArrayBuilder.DataType.FLOAT, false, 48);
        builder.setVertexAttribute(5, 2, 3, VertexArrayBuilder.DataType.FLOAT, false, 64);
        builder.setVertexAttribute(6, 2, 2, VertexArrayBuilder.DataType.FLOAT, false, 76);
        builder.setVertexAttribute(7, 2, 1, VertexArrayBuilder.DataType.UNSIGNED_SHORT, true, 84);
        builder.setVertexAttribute(8, 2, 1, VertexArrayBuilder.DataType.FLOAT, false, 86);
    }

    @Override
    @Nullable
    protected RenderType getRenderType(List<? extends LightRenderHandle<AreaLightData>> lights) {
        return VeilRenderType.get(RENDER_TYPE, new Object[0]);
    }
}

