/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.perspective;

import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3dc;
import org.joml.Vector3f;

@ApiStatus.Internal
public class LevelPerspectiveCamera
extends Camera {
    private static final Vector3f EULER_ANGLES = new Vector3f();
    private float viewDistance;

    public void setup(Vector3dc position, @Nullable Entity cameraEntity, ClientLevel level, Quaternionfc orientation, float viewDistance) {
        super.setup((BlockGetter)level, cameraEntity != null ? cameraEntity : (Entity)Objects.requireNonNull(Minecraft.getInstance().player), false, false, 1.0f);
        this.setPosition(position.x(), position.y(), position.z());
        orientation.getEulerAnglesYXZ(EULER_ANGLES);
        super.setRotation((float)((double)(-LevelPerspectiveCamera.EULER_ANGLES.y * 180.0f) / Math.PI), (float)((double)(LevelPerspectiveCamera.EULER_ANGLES.x * 180.0f) / Math.PI));
        this.rotation().set(orientation);
        this.getLookVector().set(0.0f, 0.0f, -1.0f).rotate(orientation);
        this.getUpVector().set(0.0f, 1.0f, 0.0f).rotate(orientation);
        this.getLeftVector().set(-1.0f, 0.0f, 0.0f).rotate(orientation);
        this.viewDistance = viewDistance;
    }

    public boolean isDetached() {
        return true;
    }

    public float getRenderDistance() {
        return this.viewDistance;
    }
}

