/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.modifier;

import foundry.veil.impl.client.render.shader.modifier.ShaderModificationParser;
import foundry.veil.impl.client.render.shader.modifier.ShaderModificationSyntaxException;
import foundry.veil.impl.client.render.shader.modifier.ShaderModifierLexer;
import foundry.veil.impl.client.render.shader.modifier.VeilJobParameters;
import io.github.ocelot.glslprocessor.api.GlslSyntaxException;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import java.io.IOException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface ShaderModification {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^#version\\s+(\\d+)\\s*\\w*\\s*", 8);
    public static final Pattern OUT_PATTERN = Pattern.compile("^out (\\w+) (\\w+)\\s*;\\s*", 8);
    public static final Pattern IN_PATTERN = Pattern.compile("^(?:layout\\(.*\\))?\\s*in (\\w+) (\\w+)\\s*;\\s*", 8);
    public static final Pattern UNIFORM_PATTERN = Pattern.compile("^uniform \\w+ \\w+\\s*;\\s*", 8);
    public static final Pattern RETURN_PATTERN = Pattern.compile("return\\s+.+;");
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("#(\\w+)");

    public void inject(GlslTree var1, VeilJobParameters var2) throws GlslSyntaxException, IOException;

    public int priority();

    public static ShaderModification parse(String input, boolean vertex) throws ShaderModificationSyntaxException {
        return ShaderModificationParser.parse(ShaderModifierLexer.createTokens(input), vertex);
    }

    public record Function(String name, int parameters, boolean head, String code) {
        public static Function create(String name, int parameters, boolean head, String code) {
            return new Function(name, parameters, head, code);
        }
    }
}

