/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.program;

import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.ShaderSourceSet;
import foundry.veil.api.client.render.shader.compiler.ShaderCompiler;
import foundry.veil.api.client.render.shader.compiler.ShaderException;
import foundry.veil.api.client.render.shader.compiler.VeilShaderSource;
import foundry.veil.api.client.render.shader.processor.ShaderImporter;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.impl.client.render.shader.processor.ShaderProcessorList;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import io.github.ocelot.glslprocessor.api.GlslParser;
import io.github.ocelot.glslprocessor.api.GlslSyntaxException;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import io.github.ocelot.glslprocessor.lib.anarres.cpp.LexerException;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DynamicShaderProgramImpl
extends ShaderProgramImpl {
    private final Runnable onFree;
    private final Int2ObjectMap<String> shaderSources;
    private final Int2ObjectMap<VeilShaderSource> processedShaderSources;
    private ShaderProgramImpl oldShader;

    public DynamicShaderProgramImpl(ResourceLocation id, Runnable onFree) {
        super(id);
        this.onFree = onFree;
        this.shaderSources = new Int2ObjectArrayMap();
        this.processedShaderSources = new Int2ObjectArrayMap();
        this.oldShader = null;
    }

    @Override
    protected void attachShaders(ShaderProgramImpl.CompiledProgram compiledProgram, ShaderSourceSet sourceSet, ShaderCompiler compiler) throws ShaderException {
        for (Int2ObjectMap.Entry entry : this.processedShaderSources.int2ObjectEntrySet()) {
            int glType = entry.getIntKey();
            VeilShaderSource source = (VeilShaderSource)entry.getValue();
            compiledProgram.attachShader(glType, compiler.compile(glType, source));
        }
        if (Minecraft.ON_OSX && !this.processedShaderSources.containsKey(37305) && !this.processedShaderSources.containsKey(35632)) {
            compiledProgram.attachShader(35632, compiler.compile(35632, DUMMY_FRAGMENT_SHADER));
        }
    }

    public void setShaderSources(Int2ObjectMap<String> shaderSources) {
        this.shaderSources.clear();
        this.shaderSources.putAll(shaderSources);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processShaderSources(ShaderProcessorList processorList, ShaderPreDefinitions definitions, int activeBuffers) {
        this.processedShaderSources.clear();
        ShaderPreProcessor processor = processorList.getProcessor();
        ShaderPreProcessor importProcessor = processorList.getImportProcessor();
        HashMap<String, Object> customProgramData = new HashMap<String, Object>();
        try {
            for (Int2ObjectMap.Entry shader : this.shaderSources.int2ObjectEntrySet()) {
                int type = shader.getIntKey();
                try {
                    String source = (String)shader.getValue();
                    processor.prepare();
                    importProcessor.prepare();
                    HashSet<String> dependencies = new HashSet<String>();
                    HashMap<String, String> macros = new HashMap<String, String>(definitions.getStaticDefinitions());
                    DynamicBufferType.addMacros(activeBuffers, macros);
                    VeilRenderSystem.renderer().getShaderManager().addMacros(macros);
                    GlslTree tree = GlslParser.preprocessParse((String)source, macros);
                    Object2IntArrayMap uniformBindings = new Object2IntArrayMap();
                    PreProcessorContext preProcessorContext = new PreProcessorContext(customProgramData, processorList, activeBuffers, type, (Object2IntMap<String>)uniformBindings, macros, dependencies, this.getName(), true);
                    processor.modify(preProcessorContext, tree);
                    GlslTree.stripGLMacros(macros);
                    Map treeMacros = tree.getMacros();
                    treeMacros.putAll(macros);
                    for (String dependency : dependencies) {
                        String value = definitions.getDefinition(dependency);
                        if (value == null) continue;
                        treeMacros.putIfAbsent(dependency, value);
                    }
                    this.processedShaderSources.put(type, (Object)new VeilShaderSource(null, tree.toSourceString(), (Object2IntMap<String>)uniformBindings, dependencies, new HashSet<ResourceLocation>(processorList.getShaderImporter().addedImports())));
                }
                catch (Throwable t) {
                    throw new IOException("Failed to process " + ShaderManager.getTypeName(type) + " shader", t);
                    return;
                }
            }
        }
        catch (IOException e) {
            this.processedShaderSources.clear();
            Veil.LOGGER.error("Couldn't parse dynamic shader: {}", (Object)this.getName(), (Object)e);
        }
    }

    @Override
    public void free() {
        super.free();
        this.onFree.run();
    }

    @Nullable
    public ShaderProgramImpl getOldShader() {
        return this.oldShader;
    }

    public void setOldShader(@Nullable ShaderProgramImpl program) {
        this.oldShader = program;
    }

    private record PreProcessorContext(Map<String, Object> customProgramData, ShaderProcessorList processor, int activeBuffers, int type, Object2IntMap<String> uniformBindings, Map<String, String> macros, Set<String> definitionDependencies, ResourceLocation name, boolean sourceFile) implements ShaderPreProcessor.VeilContext
    {
        @Override
        public GlslTree modifyInclude(@Nullable ResourceLocation name, String source) throws IOException, GlslSyntaxException, LexerException {
            GlslTree tree = GlslParser.preprocessParse((String)source, this.macros);
            PreProcessorContext context = new PreProcessorContext(this.customProgramData, this.processor, this.activeBuffers, this.type, this.uniformBindings, this.macros, this.definitionDependencies, name, false);
            this.processor.getImportProcessor().modify(context, tree);
            return tree;
        }

        @Override
        public void addUniformBinding(String name, int binding) {
            this.uniformBindings.put((Object)name, binding);
        }

        @Override
        public void addDefinitionDependency(String name) {
            this.definitionDependencies.add(name);
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        @Nullable
        public ProgramDefinition definition() {
            return null;
        }

        @Override
        public boolean isSourceFile() {
            return this.sourceFile;
        }

        @Override
        public ShaderImporter shaderImporter() {
            return this.processor.getShaderImporter();
        }
    }
}

