/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.vertex;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.vertex.VertexArray;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBVertexAttrib64Bit;
import org.lwjgl.opengl.GL33C;

@ApiStatus.Internal
public class LegacyVertexAttribBindingBuilder
implements VertexArrayBuilder {
    private final VertexArray vertexArray;
    private final VertexBufferRegion[] vertexBuffers;
    private final VertexAttribute[] vertexAttributes;
    private int boundIndex = -1;

    public LegacyVertexAttribBindingBuilder(VertexArray vertexArray) {
        this.vertexArray = vertexArray;
        this.vertexBuffers = new VertexBufferRegion[VeilRenderSystem.maxVertexAttributes()];
        this.vertexAttributes = new VertexAttribute[VeilRenderSystem.maxVertexAttributes()];
    }

    private void bindIndex(int index) {
        if (index < 0 || index >= this.vertexBuffers.length) {
            throw new IllegalArgumentException("Invalid vertex attribute index. Must be between 0 and " + (this.vertexBuffers.length - 1) + ": " + index);
        }
        if (this.boundIndex != index) {
            if (this.vertexBuffers[index] == null) {
                throw new IllegalArgumentException("No vertex buffer defined for index: " + index);
            }
            RenderSystem.glBindBuffer((int)34962, (int)this.vertexBuffers[index].buffer);
            this.boundIndex = index;
        }
    }

    private void setAttribute(int index, VertexAttribute attribute) {
        this.vertexAttributes[index] = attribute;
        VertexBufferRegion buffer = this.vertexBuffers[attribute.bufferIndex()];
        if (buffer != null) {
            this.bindIndex(attribute.bufferIndex());
            attribute.apply(index, buffer);
        }
    }

    @Override
    public VertexArray vertexArray() {
        return this.vertexArray;
    }

    @Override
    public VertexArrayBuilder defineVertexBuffer(int index, int buffer, int offset, int stride, int divisor) {
        if (index < 0 || index >= this.vertexBuffers.length) {
            throw new IllegalArgumentException("Invalid vertex attribute index. Must be between 0 and " + (this.vertexBuffers.length - 1) + ": " + index);
        }
        this.vertexBuffers[index] = new VertexBufferRegion(buffer, offset, stride, divisor);
        this.bindIndex(index);
        for (VertexAttribute attribute : this.vertexAttributes) {
            if (attribute == null || attribute.bufferIndex() != index) continue;
            attribute.apply(index, this.vertexBuffers[index]);
        }
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, boolean normalized, int relativeOffset) {
        VertexArrayBuilder.validateFloatType(type, size);
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        GL33C.glEnableVertexAttribArray((int)index);
        this.setAttribute(index, new FloatAttribute(bufferIndex, size, type, normalized, relativeOffset));
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexIAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, int relativeOffset) {
        VertexArrayBuilder.validateIntType(type);
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        GL33C.glEnableVertexAttribArray((int)index);
        this.setAttribute(index, new IntAttribute(bufferIndex, size, type, relativeOffset));
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexLAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, int relativeOffset) {
        VertexArrayBuilder.validateLongType(type);
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        GL33C.glEnableVertexAttribArray((int)index);
        this.setAttribute(index, new LongAttribute(bufferIndex, size, type, relativeOffset));
        return this;
    }

    @Override
    public VertexArrayBuilder removeVertexBuffer(int index) {
        if (index < 0 || index >= this.vertexBuffers.length) {
            throw new IllegalArgumentException("Invalid vertex attribute index. Must be between 0 and " + (this.vertexBuffers.length - 1) + ": " + index);
        }
        this.vertexBuffers[index] = null;
        return this;
    }

    @Override
    public VertexArrayBuilder removeAttribute(int index) {
        GL33C.glDisableVertexAttribArray((int)index);
        this.vertexAttributes[index] = null;
        return this;
    }

    @Override
    public VertexArrayBuilder clearVertexBuffers() {
        Arrays.fill(this.vertexBuffers, null);
        return this;
    }

    @Override
    public VertexArrayBuilder clearVertexAttributes() {
        for (int i = 0; i < this.vertexAttributes.length; ++i) {
            GL33C.glDisableVertexAttribArray((int)i);
        }
        Arrays.fill(this.vertexAttributes, null);
        return this;
    }

    private record VertexBufferRegion(int buffer, int offset, int stride, int divisor) {
    }

    private static sealed interface VertexAttribute
    permits FloatAttribute, IntAttribute, LongAttribute {
        public int bufferIndex();

        public void apply(int var1, VertexBufferRegion var2);
    }

    private record FloatAttribute(int bufferIndex, int size, VertexArrayBuilder.DataType type, boolean normalized, int relativeOffset) implements VertexAttribute
    {
        @Override
        public void apply(int index, VertexBufferRegion region) {
            GL33C.glVertexAttribPointer((int)index, (int)this.size, (int)this.type.getGlType(), (boolean)this.normalized, (int)region.stride, (long)(region.offset + this.relativeOffset));
            GL33C.glVertexAttribDivisor((int)index, (int)region.divisor);
        }
    }

    private record IntAttribute(int bufferIndex, int size, VertexArrayBuilder.DataType type, int relativeOffset) implements VertexAttribute
    {
        @Override
        public void apply(int index, VertexBufferRegion region) {
            GL33C.glVertexAttribIPointer((int)index, (int)this.size, (int)this.type.getGlType(), (int)region.stride, (long)(region.offset + this.relativeOffset));
            GL33C.glVertexAttribDivisor((int)index, (int)region.divisor);
        }
    }

    private record LongAttribute(int bufferIndex, int size, VertexArrayBuilder.DataType type, int relativeOffset) implements VertexAttribute
    {
        @Override
        public void apply(int index, VertexBufferRegion region) {
            ARBVertexAttrib64Bit.glVertexAttribLPointer((int)index, (int)this.size, (int)this.type.getGlType(), (int)region.stride, (long)(region.offset + this.relativeOffset));
            GL33C.glVertexAttribDivisor((int)index, (int)region.divisor);
        }
    }
}

