/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.wrapper;

import com.mojang.blaze3d.shaders.Uniform;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL41C;
import org.lwjgl.system.MemoryStack;

@ApiStatus.Internal
public class VanillaUniformWrapper
extends Uniform {
    private final int programId;
    private int location;

    public VanillaUniformWrapper(int shaderId, String name) {
        super(name, 0, 0, null);
        this.close();
        this.programId = shaderId;
        this.location = -1;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public void set(int index, float value) {
        throw new UnsupportedOperationException("Use absolute set");
    }

    public void set(float value) {
        if (this.location != -1) {
            GL41C.glProgramUniform1f((int)this.programId, (int)this.location, (float)value);
        }
    }

    public void set(float x, float y) {
        if (this.location != -1) {
            GL41C.glProgramUniform2f((int)this.programId, (int)this.location, (float)x, (float)y);
        }
    }

    public void set(float x, float y, float z) {
        if (this.location != -1) {
            GL41C.glProgramUniform3f((int)this.programId, (int)this.location, (float)x, (float)y, (float)z);
        }
    }

    public void set(float x, float y, float z, float w) {
        if (this.location != -1) {
            GL41C.glProgramUniform4f((int)this.programId, (int)this.location, (float)x, (float)y, (float)z, (float)w);
        }
    }

    public void set(@NotNull Vector3f value) {
        this.set(value.x, value.y, value.z);
    }

    public void set(@NotNull Vector4f value) {
        this.set(value.x, value.y, value.z, value.w);
    }

    public void setSafe(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public void set(int value) {
        if (this.location != -1) {
            GL41C.glProgramUniform1i((int)this.programId, (int)this.location, (int)value);
        }
    }

    public void set(int x, int y) {
        if (this.location != -1) {
            GL41C.glProgramUniform2i((int)this.programId, (int)this.location, (int)x, (int)y);
        }
    }

    public void set(int x, int y, int z) {
        if (this.location != -1) {
            GL41C.glProgramUniform3i((int)this.programId, (int)this.location, (int)x, (int)y, (int)z);
        }
    }

    public void set(int x, int y, int z, int w) {
        if (this.location != -1) {
            GL41C.glProgramUniform4i((int)this.programId, (int)this.location, (int)x, (int)y, (int)z, (int)w);
        }
    }

    public void setSafe(int x, int y, int z, int w) {
        this.set(x, y, z, w);
    }

    public void set(float[] values) {
        switch (values.length) {
            case 1: {
                this.set(values[0]);
                break;
            }
            case 2: {
                this.set(values[0], values[1]);
                break;
            }
            case 3: {
                this.set(values[0], values[1], values[2]);
                break;
            }
            case 4: {
                this.set(values[0], values[1], values[2], values[3]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid value array: " + Arrays.toString(values));
            }
        }
    }

    public void setMat2x2(float $$0, float $$1, float $$2, float $$3) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    public void setMat2x3(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    public void setMat2x4(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    public void setMat3x2(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    public void setMat3x3(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    public void setMat3x4(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    public void setMat4x2(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    public void setMat4x3(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    public void setMat4x4(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11, float $$12, float $$13, float $$14, float $$15) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    public void set(@NotNull Matrix3f value) {
        if (this.location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(9);
            value.get(buffer);
            GL41C.glProgramUniformMatrix3fv((int)this.programId, (int)this.location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    public void set(@NotNull Matrix4f value) {
        if (this.location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(16);
            value.get(buffer);
            GL41C.glProgramUniformMatrix4fv((int)this.programId, (int)this.location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    public void upload() {
    }

    public int getLocation() {
        return this.location;
    }
}

