/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.dynamicbuffer.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.render.ext.VeilDebug;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.client.render.dynamicbuffer.VanillaShaderCompiler;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import foundry.veil.mixin.dynamicbuffer.accessor.DynamicBufferProgramAccessor;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL20C;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderInstance.class})
public abstract class DynamicBufferShaderInstanceMixin
implements Shader,
ShaderInstanceExtension {
    @Mutable
    @Shadow
    @Final
    private Program vertexProgram;
    @Mutable
    @Shadow
    @Final
    private Program fragmentProgram;
    @Mutable
    @Shadow
    @Final
    private int programId;
    @Shadow
    @Final
    private VertexFormat vertexFormat;
    @Shadow
    @Final
    public Map<String, Uniform> uniformMap;
    @Shadow
    @Final
    private List<Integer> uniformLocations;
    @Shadow
    @Final
    private List<Integer> samplerLocations;
    @Shadow
    @Final
    private String name;
    @Shadow
    @Final
    private List<Uniform> uniforms;
    @Unique
    private String veil$vertexSource;
    @Unique
    private String veil$fragmentSource;
    @Unique
    private int veil$activeBuffers;
    @Unique
    private final Int2IntMap veil$programCache = new Int2IntArrayMap(1);

    @Shadow
    protected abstract void updateLocations();

    @Shadow
    public abstract void attachToProgram();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        this.veil$programCache.put(0, this.programId);
        if (this instanceof ShaderProgramImpl.Wrapper) {
            return;
        }
        VeilDebug debug = VeilDebug.get();
        debug.objectLabel(33506, this.programId, "Vanilla Shader Program " + this.name + ":default");
        debug.objectLabel(33505, ((DynamicBufferProgramAccessor)this.vertexProgram).getId(), "Vanilla vertex Shader " + this.vertexProgram.getName() + ":default");
        debug.objectLabel(33505, ((DynamicBufferProgramAccessor)this.fragmentProgram).getId(), "Vanilla fragment Shader " + this.fragmentProgram.getName() + ":default");
    }

    @Inject(method={"apply"}, at={@At(value="HEAD")})
    public void apply(CallbackInfo ci) {
        if (Veil.platform().hasErrors()) {
            return;
        }
        VanillaShaderCompiler.markRendered(this.name);
        this.veil$applyCompile();
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    public void close(CallbackInfo ci) {
        if (this.veil$programCache.isEmpty()) {
            return;
        }
        this.programId = this.veil$programCache.remove(0);
        IntIterator intIterator = this.veil$programCache.values().iterator();
        while (intIterator.hasNext()) {
            int program = (Integer)intIterator.next();
            GL20C.glDeleteProgram((int)program);
        }
        this.veil$programCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void veil$applyCompile() {
        if (this.veil$vertexSource != null && this.veil$fragmentSource != null) {
            int oldProgram = this.programId;
            this.programId = GL20C.glCreateProgram();
            int vertexShader = GL20C.glCreateShader((int)35633);
            int fragmentShader = GL20C.glCreateShader((int)35632);
            try {
                GlStateManager.glShaderSource((int)vertexShader, List.of(this.veil$vertexSource));
                GL20C.glCompileShader((int)vertexShader);
                if (GL20C.glGetShaderi((int)vertexShader, (int)35713) != 1) {
                    String error = GL20C.glGetShaderInfoLog((int)vertexShader).trim();
                    throw new IOException("Couldn't compile dynamic vertex program (" + this.vertexProgram.getName() + ", " + this.name + ") : " + error);
                }
                GlStateManager.glShaderSource((int)fragmentShader, List.of(this.veil$fragmentSource));
                GL20C.glCompileShader((int)fragmentShader);
                if (GL20C.glGetShaderi((int)fragmentShader, (int)35713) != 1) {
                    String error = GL20C.glGetShaderInfoLog((int)fragmentShader).trim();
                    throw new IOException("Couldn't compile dynamic fragment program (" + this.fragmentProgram.getName() + ", " + this.name + ") : " + error);
                }
                int index = 0;
                for (String name : this.vertexFormat.getElementAttributeNames()) {
                    GL20C.glBindAttribLocation((int)this.programId, (int)index, (CharSequence)name);
                    ++index;
                }
                DynamicBufferProgramAccessor vertexAccessor = (DynamicBufferProgramAccessor)this.vertexProgram;
                DynamicBufferProgramAccessor fragmentAccessor = (DynamicBufferProgramAccessor)this.fragmentProgram;
                int oldVertex = vertexAccessor.getId();
                int oldFragment = fragmentAccessor.getId();
                vertexAccessor.setId(vertexShader);
                fragmentAccessor.setId(fragmentShader);
                this.attachToProgram();
                vertexAccessor.setId(oldVertex);
                fragmentAccessor.setId(oldFragment);
                GL20C.glLinkProgram((int)this.programId);
                if (GL20C.glGetProgrami((int)this.programId, (int)35714) != 1) {
                    String error = GL20C.glGetProgramInfoLog((int)this.programId).trim();
                    throw new IOException("Couldn't link shader (" + this.name + ") : " + error);
                }
                this.veil$invalidate();
                int old = this.veil$programCache.put(this.veil$activeBuffers, this.programId);
                if (old != 0) {
                    GL20C.glDeleteProgram((int)old);
                }
                String type = this.veil$activeBuffers == 0 ? "default" : Integer.toString(this.veil$activeBuffers);
                VeilDebug debug = VeilDebug.get();
                debug.objectLabel(33506, this.programId, "Vanilla Shader Program " + this.name + ":" + type);
                debug.objectLabel(33505, vertexShader, "Vanilla vertex Shader " + this.vertexProgram.getName() + ":" + type);
                debug.objectLabel(33505, fragmentShader, "Vanilla fragment Shader " + this.fragmentProgram.getName() + ":" + type);
            }
            catch (Throwable t) {
                this.veil$programCache.remove(this.veil$activeBuffers);
                GL20C.glDeleteProgram((int)this.programId);
                this.programId = oldProgram;
                Veil.LOGGER.error("Failed to recompile vanilla shader: {}", (Object)this.name, (Object)t);
            }
            finally {
                GL20C.glDeleteShader((int)vertexShader);
                GL20C.glDeleteShader((int)fragmentShader);
            }
            this.veil$vertexSource = null;
            this.veil$fragmentSource = null;
        }
    }

    @Unique
    private void veil$invalidate() {
        this.samplerLocations.clear();
        this.uniformLocations.clear();
        this.uniformMap.clear();
        for (Uniform uniform : this.uniforms) {
            uniform.setLocation(-1);
        }
        this.updateLocations();
        this.markDirty();
    }

    @Override
    public Collection<ResourceLocation> veil$getShaderSources() {
        ResourceLocation vertexProgramName = ResourceLocation.parse((String)this.vertexProgram.getName());
        ResourceLocation fragmentProgramName = ResourceLocation.parse((String)this.fragmentProgram.getName());
        ResourceLocation vertexPath = ResourceLocation.fromNamespaceAndPath((String)vertexProgramName.getNamespace(), (String)("shaders/core/" + vertexProgramName.getPath() + Program.Type.VERTEX.getExtension()));
        ResourceLocation fragmentPath = ResourceLocation.fromNamespaceAndPath((String)fragmentProgramName.getNamespace(), (String)("shaders/core/" + fragmentProgramName.getPath() + Program.Type.FRAGMENT.getExtension()));
        return List.of(vertexPath, fragmentPath);
    }

    @Override
    public boolean veil$swapBuffers(int activeBuffers) {
        if (this.veil$activeBuffers == activeBuffers) {
            return false;
        }
        this.veil$applyCompile();
        int programId = this.veil$programCache.get(activeBuffers);
        if (programId != 0) {
            this.veil$activeBuffers = activeBuffers;
            this.programId = programId;
            this.veil$invalidate();
            return false;
        }
        return true;
    }

    @Override
    public void veil$recompile(boolean vertex, String source, int activeBuffers) {
        if (this.veil$activeBuffers != activeBuffers) {
            this.veil$vertexSource = null;
            this.veil$fragmentSource = null;
        }
        this.veil$activeBuffers = activeBuffers;
        if (vertex) {
            this.veil$vertexSource = source;
        } else {
            this.veil$fragmentSource = source;
        }
    }

    @Override
    public int veil$getActiveBuffers() {
        return this.veil$activeBuffers;
    }
}

