package foundry.veil.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_4309;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;

/**
 * Loads files similarly to {@link class_4309},
 * but also decodes them using the provided codec.
 *
 * @param <T> The type of mapped data to return
 * @see Codec
 * @since 1.0.0
 */
public abstract class CodecReloadListener<T> extends class_4080<Map<class_2960, T>> {

    protected final Codec<T> codec;
    protected final class_7654 converter;
    private final class_7225.class_7874 registries;

    /**
     * Creates a new codec reload listener.
     *
     * @param codec     The codec to use when deserializing files
     * @param converter The converter to use for listing files
     */
    public CodecReloadListener(Codec<T> codec, class_7654 converter) {
        this(codec, converter, null);
    }

    /**
     * Creates a new codec reload listener.
     *
     * @param codec     The codec to use when deserializing files
     * @param converter The converter to use for listing files
     */
    public CodecReloadListener(Codec<T> codec, class_7654 converter, @Nullable class_7225.class_7874 registries) {
        this.codec = codec;
        this.converter = converter;
        this.registries = registries;
    }

    @Override
    protected @NotNull Map<class_2960, T> method_18789(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        Map<class_2960, T> data = new HashMap<>();

        DynamicOps<JsonElement> ops = this.registries != null ? class_6903.method_46632(JsonOps.INSTANCE, this.registries) : JsonOps.INSTANCE;
        Map<class_2960, class_3298> resources = this.converter.method_45113(resourceManager);
        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            class_2960 location = entry.getKey();
            class_2960 id = this.converter.method_45115(location);

            try (Reader reader = entry.getValue().method_43039()) {
                JsonElement element = JsonParser.parseReader(reader);
                DataResult<T> result = this.codec.parse(ops, element);

                if (result.error().isPresent()) {
                    throw new JsonSyntaxException(result.error().get().message());
                }
                if (data.put(id, result.result().orElseThrow()) != null) {
                    throw new IllegalStateException("Duplicate data file ignored with ID " + id);
                }
            } catch (Exception e) {
                Veil.LOGGER.error("Couldn't parse data file {} from {}", id, location, e);
            }
        }

        return data;
    }
}
