package foundry.veil.api.client.property.model;

import foundry.veil.api.client.property.InapplicableProperty;
import foundry.veil.api.client.property.ModelProperty;
import gg.moonflower.molangcompiler.api.MolangExpression;
import foundry.veil.api.flare.modifier.PropertyModifier;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_3532;

/**
 * Vec3 property that specifies a rotation as a quaternion and as euler angles.
 *
 * @author GuyApooye
 */
@ModelProperty
@InapplicableProperty
public class RotationModelProperty extends Vec3ModelProperty {
    private final Quaternionfc rotation;
    private final Quaternionf overrideRotation = new Quaternionf();

    public RotationModelProperty(Vector3f value) {
        super(value);
        rotation =  new Quaternionf().rotationXYZ(value.x() * class_3532.field_29847, value.y() * class_3532.field_29847, value.z() * class_3532.field_29847);
    }

    @Override
    public void modify(Vector3f value, PropertyModifier.PropertyModifierMode mode, Optional<List<MolangExpression>> optionalMolang) {
        super.modify(value, mode, optionalMolang);
        overrideRotation.rotationXYZ(this.overrideValue.x() * class_3532.field_29847, this.overrideValue.y() * class_3532.field_29847, this.overrideValue.z() * class_3532.field_29847);
    }

    public Quaternionfc getRotation() {
        return overrideRotation;
    }

    @Override
    public void resetOverrideValue() {
        super.resetOverrideValue();
        overrideRotation.set(rotation);
    }
}
