package foundry.veil.api.client.property.properties;

import com.mojang.serialization.MapCodec;
import foundry.veil.api.client.property.Property;
import foundry.veil.api.client.registry.PropertyRegistry;
import foundry.veil.api.flare.modifier.PropertyModifier;
import gg.moonflower.molangcompiler.api.MolangExpression;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5944;

public class Sampler2DProperty extends Property<class_1044> {

    private final class_2960 source;

    public static final MapCodec<Sampler2DProperty> CODEC = class_2960.field_25139.fieldOf("value").xmap(Sampler2DProperty::new, property -> property.source);

    public Sampler2DProperty(class_2960 value) {
        super(PropertyRegistry.SAMPLER2D.get(), class_310.method_1551().method_1531().method_4619(value));
        this.source = value;
    }

    @Override
    public void applyValue(String name, class_5944 shader) {
        shader.method_34583(name, this.overrideValue.method_4624());
        // Shader must be re-applied for the sampler to take effect
        shader.method_34586();
    }

    @Override
    public void modify(class_1044 value, PropertyModifier.PropertyModifierMode mode, Optional<List<MolangExpression>> optionalMolang) {
        this.overrideValue = value;
    }

    @Override
    protected class_1044 cloneValue(class_1044 value) {
        return value;
    }

}
