package foundry.veil.api.client.registry;

import foundry.veil.Veil;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.editor.*;
import foundry.veil.api.resource.type.*;
import foundry.veil.platform.registry.RegistrationProvider;
import foundry.veil.platform.registry.RegistryObject;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import org.jetbrains.annotations.ApiStatus;

/**
 * Registry for resource editor types.
 */
public final class VeilResourceEditorRegistry {

    public static final class_5321<class_2378<ResourceFileEditor.Factory<?>>> REGISTRY_KEY = class_5321.method_29180(Veil.veilPath("resource_editor"));
    private static final RegistrationProvider<ResourceFileEditor.Factory<?>> VANILLA_PROVIDER = RegistrationProvider.get(REGISTRY_KEY, Veil.MODID);
    public static final class_2378<ResourceFileEditor.Factory<?>> REGISTRY = VANILLA_PROVIDER.asVanillaRegistry();

    public static final RegistryObject<ResourceFileEditor.Factory<VeilTextResource<?>>> TEXT = VANILLA_PROVIDER.register("text", () -> TextFileEditor::new);
    public static final RegistryObject<BlockModelInspector.Factory<BlockModelResource>> BLOCK_MODEL = VANILLA_PROVIDER.register("block_model", () -> BlockModelInspector::new);
    public static final RegistryObject<ResourceFileEditor.Factory<FramebufferResource>> FRAMEBUFFER = VANILLA_PROVIDER.register("framebuffer", () -> FramebufferFileEditor::new);
    public static final RegistryObject<ResourceFileEditor.Factory<ShellResource>> SHELL = VANILLA_PROVIDER.register("flare_shell", () -> ShellInspector::new);
    public static final RegistryObject<ResourceFileEditor.Factory<FlareResource>> EFFECT = VANILLA_PROVIDER.register("flare_effect", () -> EffectInspector::new);

    public static final RegistryObject<ResourceOverrideEditor.Factory<VeilResource<?>>> OVERRIDE = VANILLA_PROVIDER.register("override", () -> ResourceOverrideEditor::new);

    private VeilResourceEditorRegistry() {
    }

    @ApiStatus.Internal
    public static void bootstrap() {
    }
}
