package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.NativeResource;

import javax.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.minecraft.class_9801;

public class CachedBufferSource implements class_4597, NativeResource {

    private final Object2ObjectMap<class_1921, class_9799> buffers = new Object2ObjectArrayMap<>();
    private final Object2ObjectMap<class_1921, class_287> startedBuilders = new Object2ObjectArrayMap<>();

    @Nullable
    private class_1921 lastSharedType;

    private void clearBuffers() {
        this.buffers.values().forEach(class_9799::method_60809);
        this.buffers.clear();
    }

    @Override
    public @NotNull class_4588 getBuffer(@NotNull class_1921 renderType) {
        class_287 last = this.startedBuilders.get(renderType);
        if (last != null && !renderType.method_43332()) {
            this.endBatch(renderType, last);
        }

        if (last != null) {
            return last;
        }

        class_9799 bytebufferbuilder = this.buffers.computeIfAbsent(renderType, unused -> new class_9799(renderType.method_22722()));
        class_287 builder = new class_287(bytebufferbuilder, renderType.method_23033(), renderType.method_23031());
        this.startedBuilders.put(renderType, builder);
        return builder;
    }

    @Override
    public void free() {
        this.clearBuffers();
        this.startedBuilders.clear();
        this.lastSharedType = null;
    }

    public void endLastBatch() {
        if (this.lastSharedType != null) {
            this.endBatch(this.lastSharedType);
            this.lastSharedType = null;
        }
    }

    public void endBatch() {
        this.endLastBatch();

        for (class_1921 rendertype : this.buffers.keySet()) {
            this.endBatch(rendertype);
        }

        this.clearBuffers();
    }

    public void endBatch(class_1921 renderType) {
        class_287 bufferbuilder = this.startedBuilders.remove(renderType);
        if (bufferbuilder != null) {
            this.endBatch(renderType, bufferbuilder);
        }
    }

    private void endBatch(class_1921 renderType, class_287 builder) {
        class_9801 meshdata = builder.method_60794();
        if (meshdata != null) {
            if (renderType.method_60894()) {
                class_9799 bytebufferbuilder = this.buffers.computeIfAbsent(renderType, unused -> new class_9799(renderType.method_22722()));
                meshdata.method_60819(bytebufferbuilder, RenderSystem.getVertexSorting());
            }

            renderType.method_60895(meshdata);
        }

        if (renderType.equals(this.lastSharedType)) {
            this.lastSharedType = null;
        }
    }
}
