package foundry.veil.api.client.render.framebuffer;

import foundry.veil.Veil;
import net.minecraft.class_2960;

/**
 * Default framebuffer names for use with {@link FramebufferManager#getFramebuffer(class_2960)}.
 *
 * @author Ocelot
 */
public final class VeilFramebuffers {

    private VeilFramebuffers() {
    }

    public static final class_2960 MAIN = class_2960.method_60656("main");
    public static final class_2960 FIRST_PERSON = buffer("first_person");
    public static final class_2960 BLOOM = buffer("bloom");
    public static final class_2960 LIGHT = buffer("light");
    public static final class_2960 POST = buffer("post");

    public static final class_2960 TRANSLUCENT_TARGET = transparency("translucent");
    public static final class_2960 ITEM_ENTITY_TARGET = transparency("item_entity");
    public static final class_2960 PARTICLES_TARGET = transparency("particles");
    public static final class_2960 WEATHER_TARGET = transparency("weather");
    public static final class_2960 CLOUDS_TARGET = transparency("clouds");

    private static class_2960 transparency(String name) {
        return class_2960.method_60656(name);
    }

    private static class_2960 buffer(String name) {
        return Veil.veilPath(name);
    }
}
