package foundry.veil.api.client.render.rendertype.layer;

import com.mojang.serialization.MapCodec;
import foundry.veil.api.client.registry.RenderTypeLayerRegistry;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeBuilder;
import net.minecraft.class_4668;

public record LayeringLayer(LayerTemplateValue<LayeringState> mode) implements RenderTypeLayer {

    public static final MapCodec<LayeringLayer> CODEC = LayerTemplateValue.enumCodec(LayeringState.class)
            .optionalFieldOf("mode", LayerTemplateValue.raw(LayeringState.POLYGON_OFFSET))
            .xmap(LayeringLayer::new, LayeringLayer::mode);

    @Override
    public void addShard(VeilRenderTypeBuilder builder, Object... params) {
        builder.layeringState(this.mode.parse(params).shard);
    }

    @Override
    public RenderTypeLayerRegistry.LayerType<?> getType() {
        return RenderTypeLayerRegistry.LAYERING.get();
    }

    public enum LayeringState {
        NONE(VeilRenderType.noLayering()),
        POLYGON_OFFSET(VeilRenderType.polygonOffsetLayering()),
        VIEW_OFFSET(VeilRenderType.viewOffsetLayering());

        private final class_4668.class_4675 shard;

        LayeringState(class_4668.class_4675 shard) {
            this.shard = shard;
        }

        public class_4668.class_4675 getShard() {
            return this.shard;
        }
    }
}
