package foundry.veil.api.flare.data.effect;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.flare.EffectHost;
import foundry.veil.api.flare.FlareEffectManager;
import foundry.veil.api.flare.model.BakedShell;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

import static foundry.veil.Veil.LOGGER;

/**
 * @since 2.5.0
 */
public record FlareSubModule(List<class_2960> templates) {

    public static final Codec<FlareSubModule> CODEC = Codec.either(
                    class_2960.field_25139.listOf(),
                    class_2960.field_25139
            )
            .xmap(either -> either.map(FlareSubModule::new, single -> new FlareSubModule(List.of(single))),
                    subModule -> subModule.templates.size() == 1 ? Either.right(subModule.templates.getFirst()) : Either.left(subModule.templates));

    public FlareSubModule(List<class_2960> templates) {
        this.templates = Collections.unmodifiableList(templates);
    }

    public void render(EffectHost host, MatrixStack matrixStack, float partialTick) {
        this.render(host, matrixStack, partialTick, null);
    }

    public void render(EffectHost host, MatrixStack matrixStack, float partialTick, @Nullable Map<class_2960, BakedShell> shellOverrides) {
        for (class_2960 templateLocation : this.templates) {
            FlareEffectTemplate template = FlareEffectManager.getTemplate(templateLocation);
            if (template == null) {
                LOGGER.error("Template {} could not be found!", templateLocation);
                continue;
            }
            template.render(host, matrixStack, partialTick, shellOverrides);
        }
    }
}
