package foundry.veil.api.flare.data.model;

import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import org.joml.Vector3fc;

/**
 * @since 2.5.0
 */
public record FlareBakedQuad(float[] vertexData, Vector3fc normal) {

    public void putBakedQuadInto(class_4588 buffer) {
        this.putBakedQuadInto(buffer, 1.0F, 1.0F, 1.0F, 1.0F, class_765.field_32767, class_4608.field_21444);
    }

    public void putBakedQuadInto(class_4588 buffer, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
        float[] vertexData = this.vertexData();
        Vector3fc normal = this.normal();

        for (int i = 0; i < 4; i++) {
            int j = i * 5;
            buffer.method_22912(vertexData[j], vertexData[j + 1], vertexData[j + 2])
                    .method_22913(vertexData[j + 3], vertexData[j + 4])
                    .method_22914(normal.x(), normal.y(), normal.z())
                    .method_22915(red, green, blue, alpha)
                    .method_60803(packedLight)
                    .method_22922(packedOverlay);

        }
    }

    public void putBakedQuadInto(class_4588 buffer, float red, float green, float blue, float alpha, int[] lightmap, int packedOverlay) {
        float[] vertexData = this.vertexData();
        Vector3fc normal = this.normal();

        for (int i = 0; i < 4; i++) {
            int j = i * 5;
            buffer.method_22912(vertexData[j], vertexData[j + 1], vertexData[j + 2])
                    .method_22913(vertexData[j + 3], vertexData[j + 4])
                    .method_22914(normal.x(), normal.y(), normal.z())
                    .method_22915(red, green, blue, alpha)
                    .method_60803(lightmap[i])
                    .method_22922(packedOverlay);
        }
    }
}
