package foundry.veil.api.flare.data.model;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.util.CodecUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2350;

/**
 * @since 2.5.0
 */
public record ShellElement(
        Vector3fc from,
        Vector3fc to,
        @Nullable ShellElementRotation rotation,
        Map<class_2350, ShellElementFace> faces
) {
    public static final Codec<ShellElement> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            CodecUtil.VECTOR3FC_CODEC.fieldOf("from").forGetter(ShellElement::from),
            CodecUtil.VECTOR3FC_CODEC.fieldOf("to").forGetter(ShellElement::to),
            ShellElementRotation.CODEC.optionalFieldOf("rotation").forGetter(element -> Optional.ofNullable(element.rotation)),
            ShellElementFace.FULL_CODEC.fieldOf("faces").forGetter(ShellElement::faces)
    ).apply(instance, (from, to, rotation, faces) -> {
        Map<class_2350, ShellElementFace> facesMap = faces.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new EnumMap<>(faces));
        return new ShellElement(from, to, rotation.orElse(null), facesMap);
    }));
}
