package foundry.veil.api.network.handler;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_7648;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

/**
 * Common context for packet handling.
 *
 * @author Ocelot
 */
public interface PacketContext {

    /**
     * @return The player that received the payload
     */
    @Nullable
    class_1657 player();

    /**
     * @return The level the context player is on
     */
    default @Nullable class_1937 level() {
        class_1657 player = this.player();
        return player != null ? player.method_37908() : null;
    }

    /**
     * Creates a packet from a packet payload.
     *
     * @param payload the packet payload
     */
    class_2596<?> createPacket(class_8710 payload);

    /**
     * Sends a packet to the other side.
     *
     * @param payload the payload to create a packet from
     */
    default void sendPacket(class_8710 payload) {
        this.sendPacket(this.createPacket(payload), null);
    }

    /**
     * Sends a packet to the other side.
     *
     * @param payload  the payload to create a packet from
     * @param callback an optional callback to execute after the packet is sent, may be <code>null</code>.
     */
    default void sendPacket(class_8710 payload, @Nullable class_7648 callback) {
        this.sendPacket(this.createPacket(payload), callback);
    }

    /**
     * Sends a packet.
     *
     * @param packet the payload
     */
    default void sendPacket(class_2596<?> packet) {
        this.sendPacket(packet, null);
    }

    /**
     * Sends a packet.
     *
     * @param packet   the payload
     * @param callback an optional callback to execute after the packet is sent, may be {@code null}.
     */
    void sendPacket(class_2596<?> packet, @Nullable class_7648 callback);

    /**
     * Disconnects the player.
     *
     * @param disconnectReason the reason for disconnection
     */
    void disconnect(class_2561 disconnectReason);
}
