package foundry.veil.api.quasar.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.quasar.emitters.shape.EmitterShape;
import foundry.veil.api.util.CodecUtil;
import net.minecraft.class_2960;
import net.minecraft.class_5381;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public record EmitterShapeSettings(EmitterShape shape,
                                   Vector3fc dimensions,
                                   Vector3fc rotation,
                                   boolean fromSurface) {

    public static final Codec<EmitterShapeSettings> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group(
            EmitterShape.CODEC.fieldOf("shape").forGetter(EmitterShapeSettings::shape),
            CodecUtil.VECTOR3FC_CODEC.fieldOf("dimensions").forGetter(EmitterShapeSettings::dimensions),
            CodecUtil.VECTOR3FC_CODEC.fieldOf("rotation").forGetter(EmitterShapeSettings::rotation),
            Codec.BOOL.fieldOf("from_surface").forGetter(EmitterShapeSettings::fromSurface)
    ).apply(instance, EmitterShapeSettings::new));
    public static final Codec<class_6880<EmitterShapeSettings>> CODEC = class_5381.method_29749(QuasarParticles.EMITTER_SHAPE_SETTINGS, DIRECT_CODEC);

    public Vector3d getPos(class_5819 randomSource, Vector3dc pos) {
        return this.shape.getPoint(randomSource, this.dimensions, this.rotation, pos, this.fromSurface);
    }

    public @Nullable class_2960 getRegistryId() {
        return QuasarParticles.registryAccess().method_33310(QuasarParticles.EMITTER_SHAPE_SETTINGS).map(registry -> registry.method_10221(this)).orElse(null);
    }
}
