package foundry.veil.api.quasar.data.module;

import com.mojang.serialization.Codec;
import foundry.veil.api.quasar.data.ParticleModuleTypeRegistry;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.particle.ParticleModuleSet;
import net.minecraft.class_5381;
import net.minecraft.class_6880;

public interface ParticleModuleData {

    Codec<ParticleModuleData> INIT_DIRECT_CODEC = ParticleModuleTypeRegistry.INIT_MODULE_CODEC
            .dispatch("module", ParticleModuleData::getType, ModuleType::codec);
    Codec<ParticleModuleData> UPDATE_DIRECT_CODEC = ParticleModuleTypeRegistry.UPDATE_MODULE_CODEC
            .dispatch("module", ParticleModuleData::getType, ModuleType::codec);
    Codec<ParticleModuleData> RENDER_DIRECT_CODEC = ParticleModuleTypeRegistry.RENDER_MODULE_CODEC
            .dispatch("module", ParticleModuleData::getType, ModuleType::codec);

    Codec<class_6880<ParticleModuleData>> INIT_CODEC = class_5381.method_29749(QuasarParticles.INIT_MODULES, INIT_DIRECT_CODEC);
    Codec<class_6880<ParticleModuleData>> UPDATE_CODEC = class_5381.method_29749(QuasarParticles.UPDATE_MODULES, UPDATE_DIRECT_CODEC);
    Codec<class_6880<ParticleModuleData>> RENDER_CODEC = class_5381.method_29749(QuasarParticles.RENDER_MODULES, RENDER_DIRECT_CODEC);

    void addModules(ParticleModuleSet.Builder builder);

    ModuleType<?> getType();
}
