package foundry.veil.api.quasar.emitters.shape;

import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Hemisphere implements EmitterShape {

    @Override
    public Vector3d getPoint(class_5819 randomSource, Vector3fc dimensions, Vector3fc rotation, Vector3dc position, boolean fromSurface) {
        double theta = randomSource.method_43058() * 2 * Math.PI;
        double phi = randomSource.method_43058() * Math.PI / 2;
        double x = Math.cos(theta) * Math.sin(phi);
        double y = Math.sin(theta) * Math.sin(phi);
        double z = Math.cos(phi);
        Vector3d normal = new Vector3d(x, y, z).normalize();
        Vector3fc dim = dimensions;
        if (!fromSurface) {
            normal.mul(randomSource.method_43058()).normalize();
            dim = dimensions.mul(
                    randomSource.method_43057(),
                    randomSource.method_43057(),
                    randomSource.method_43057(),
                    new Vector3f()
            );
        }
        Vector3d pos = normal.mul(dim);
        pos = pos.rotateX((float) Math.toRadians(rotation.x())).rotateY((float) Math.toRadians(rotation.y())).rotateZ((float) Math.toRadians(rotation.z()));
        return pos.add(position);
    }

    @Override
    public void renderShape(class_4587 stack, class_4588 consumer, Vector3fc dimensions, Vector3fc rotation) {

    }
}
