package foundry.veil.impl.flare;

import foundry.veil.api.quasar.data.*;
import foundry.veil.api.resource.VeilDynamicRegistry;
import foundry.veil.Veil;
import foundry.veil.api.flare.data.effect.FlareEffectTemplate;
import foundry.veil.api.flare.data.effect.FlareModule;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2378;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7655;

import static foundry.veil.Veil.LOGGER;

@ApiStatus.Internal
public class FlareManager {

    public static final class_5321<class_2378<FlareEffectTemplate>> EFFECT_TEMPLATES = createRegistryKey("flare/templates");
    public static final class_5321<class_2378<FlareModule>> EFFECT_MODULES = createRegistryKey("flare/modules");

    private static final List<class_7655.class_7657<?>> REGISTRIES = List.of(
            new class_7655.class_7657<>(EFFECT_TEMPLATES, FlareEffectTemplate.CODEC, false),
            new class_7655.class_7657<>(EFFECT_MODULES, FlareModule.CODEC, false)
    );
    private static class_5455 registryAccess = class_5455.field_40585;

    private FlareManager() {
    }

    public static void bootstrap() {
    }

    private static <T> class_5321<class_2378<T>> createRegistryKey(String name) {
        return class_5321.method_29180(Veil.veilPath(name));
    }

    public static class_5455 registryAccess() {
        return registryAccess;
    }

    public static class Reloader implements class_3302 {

        public static final Reloader INSTANCE = new Reloader();

        private Reloader() {
        }

        @Override
        public @NotNull CompletableFuture<Void> method_25931(class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 preparationsProfiler, @NotNull class_3695 reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
            return VeilDynamicRegistry.loadRegistries(resourceManager, REGISTRIES, backgroundExecutor)
                    .thenCompose(preparationBarrier::method_18352)
                    .thenAcceptAsync(data -> {
                        registryAccess = data.registryAccess();
                        data.errors().values().forEach(Exception::printStackTrace);
                        String msg = VeilDynamicRegistry.printErrors(data.errors());
                        if (msg != null) {
                            LOGGER.error("Flare registry loading errors:{}", msg);
                        }
                        LOGGER.info("Loaded {} templates", registryAccess.method_30530(EFFECT_TEMPLATES).method_10204());
                        LOGGER.info("Loaded {} modules", registryAccess.method_30530(EFFECT_MODULES).method_10204());
                    }, gameExecutor);
        }

        @Override
        public @NotNull String method_22322() {
            return QuasarParticles.class.getSimpleName();
        }
    }
}
