package foundry.veil.impl.flare;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import foundry.veil.api.flare.data.model.FlareShell;
import foundry.veil.api.flare.model.BakedShell;
import foundry.veil.api.flare.model.ShellBakery;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.NativeResource;

import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;

@ApiStatus.Internal
public class ShellManager extends class_4080<Map<class_2960, BakedShell>> implements NativeResource {

    private static final class_7654 CONVERTER = class_7654.method_45114("flare/shells");

    private Map<class_2960, BakedShell> shells;

    public ShellManager() {
        this.shells = Map.of();
    }

    @Override
    protected @NotNull Map<class_2960, BakedShell> method_18789(@NotNull class_3300 resourceManager, @NotNull class_3695 profiler) {
        Map<class_2960, BakedShell> data = new HashMap<>();

        Map<class_2960, class_3298> resources = CONVERTER.method_45113(resourceManager);
        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            class_2960 location = entry.getKey();
            class_2960 id = CONVERTER.method_45115(location);

            try (Reader reader = entry.getValue().method_43039()) {
                JsonElement element = JsonParser.parseReader(reader);
                DataResult<FlareShell> result = FlareShell.CODEC.parse(JsonOps.INSTANCE, element);

                if (result.error().isPresent()) {
                    throw new JsonSyntaxException(result.error().get().message());
                }

                if (data.put(id, result.result().orElseThrow().bake()) != null) {
                    throw new IllegalStateException("Duplicate data file ignored with ID " + id);
                }
            } catch (Exception e) {
                Veil.LOGGER.error("Couldn't parse data file {} from {}", id, location, e);
            }
        }

        return data;
    }

    @Override
    protected void apply(@NotNull Map<class_2960, BakedShell> map, @NotNull class_3300 resourceManager, @NotNull class_3695 profiler) {
        this.free();
        this.shells = Collections.unmodifiableMap(map);
    }

    public BakedShell getBakedShell(class_2960 shellLocation) {
        return this.shells.getOrDefault(shellLocation, ShellBakery.MISSING_SHELL);
    }

    @Override
    public void free() {
        for (BakedShell shell : this.shells.values()) {
            shell.free();
        }
        this.shells = Map.of();
    }
}
