package foundry.veil.impl.resource.loader;

import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceLoader;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.type.VanillaShaderFileResource;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5912;

public class VanillaShaderResourceLoader implements VeilResourceLoader {

    private static final Set<String> EXTENSIONS = Set.of(
            ".glsl",
            ".vsh",
            ".fsh"
    );

    @Override
    public boolean canLoad(class_3264 packType, class_2960 location, Path filePath, @Nullable Path modResourcePath) {
        if (packType != class_3264.field_14188) {
            return false;
        }

        String path = location.method_12832();
        if (path.startsWith("shaders")) {
            for (String extension : EXTENSIONS) {
                if (path.endsWith(extension)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public VeilResource<?> load(VeilResourceManager resourceManager, class_5912 provider, class_3264 packType, class_2960 location, @Nullable Path filePath, @Nullable Path modResourcePath) throws IOException {
        return new VanillaShaderFileResource(new VeilResourceInfo(packType, location, filePath, modResourcePath, false));
    }
}
