package foundry.veil.mixin.debug.client;

import foundry.veil.ext.DebugVertexBufferExt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import javax.annotation.Nullable;
import net.minecraft.class_291;
import net.minecraft.class_761;

@Mixin(class_761.class)
public class DebugLevelRendererMixin {

    @Shadow
    @Nullable
    private class_291 darkBuffer;

    @Shadow
    @Nullable
    private class_291 skyBuffer;

    @Shadow
    @Nullable
    private class_291 starBuffer;

    @Inject(method = "createDarkSky", at = @At("TAIL"))
    public void nameDarkSky(CallbackInfo ci) {
        ((DebugVertexBufferExt) this.darkBuffer).veil$setName("Void");
    }

    @Inject(method = "createLightSky", at = @At("TAIL"))
    public void nameLightSky(CallbackInfo ci) {
        ((DebugVertexBufferExt) this.skyBuffer).veil$setName("Sky");
    }

    @Inject(method = "createStars", at = @At("TAIL"))
    public void nameStars(CallbackInfo ci) {
        ((DebugVertexBufferExt) this.starBuffer).veil$setName("Star");
    }
}
