package foundry.veil.mixin.pipeline.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.texture.SimpleArrayTexture;
import foundry.veil.api.client.render.texture.SimpleCubemapTexture;
import foundry.veil.api.client.render.texture.TextureTypeMetadataSection;
import foundry.veil.api.client.render.texture.VeilPreloadedTexture;
import foundry.veil.ext.TextureManagerExtension;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

@Mixin(class_1060.class)
public abstract class PipelineTextureManagerMixin implements TextureManagerExtension {

    @Shadow
    @Final
    private Map<class_2960, class_1044> byPath;

    @Shadow
    @Final
    private class_3300 resourceManager;

    @Shadow
    public abstract void register(class_2960 path, class_1044 texture);

    @ModifyArg(method = "getTexture(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/texture/AbstractTexture;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/texture/TextureManager;register(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/renderer/texture/AbstractTexture;)V"), index = 1)
    public class_1044 wrap(class_1044 texture, @Local(argsOnly = true) class_2960 path) {
        Optional<class_3298> optionalResource = this.resourceManager.method_14486(path);
        if (optionalResource.isPresent()) {
            try {
                Optional<TextureTypeMetadataSection> section = optionalResource.get().method_14481().method_43041(TextureTypeMetadataSection.SERIALIZER);
                if (section.isPresent()) {
                    return switch (section.get().type()) {
                        case TEXTURE_2D -> texture;
                        case TEXTURE_2D_ARRAY -> new SimpleArrayTexture(path);
                        case TEXTURE_CUBE_MAP -> new SimpleCubemapTexture(path);
                    };
                }
            } catch (IOException ignored) {
            }
        }
        return texture;
    }

    @Override
    public <T extends class_1044 & VeilPreloadedTexture> CompletableFuture<?> veil$registerPreloadedTexture(class_2960 path, T texture, Executor executor) {
        if (!this.byPath.containsKey(path)) {
            this.byPath.put(path, texture);
            return texture.preload(this.resourceManager, executor).thenRunAsync(() -> this.register(path, texture), command -> class_310.method_1551().execute(() -> RenderSystem.recordRenderCall(command::run)));
        } else {
            return CompletableFuture.completedFuture(null);
        }
    }
}
