package foundry.veil.mixin.shader.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.shader.ShaderModificationManager;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.shader.modifier.ReplaceShaderModification;
import foundry.veil.impl.client.render.shader.modifier.ShaderModification;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_5944;
import net.minecraft.class_757;

@Mixin(class_757.class)
public class ShaderGameRendererMixin {

    @Inject(method = "reloadShaders", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/GameRenderer;shutdownShaders()V"))
    public void replaceShaders(CallbackInfo ci, @Local(ordinal = 1) List<Pair<class_5944, Consumer<class_5944>>> loadedShaders) {
        if (Veil.platform().hasErrors()) {
            return;
        }

        VeilRenderer renderer = VeilRenderSystem.renderer();
        ShaderModificationManager modificationManager = renderer.getShaderModificationManager();
        for (Pair<class_5944, Consumer<class_5944>> pair : loadedShaders) {
            class_2960 loc = class_2960.method_12829(pair.getFirst().method_35787());
            if (loc == null) {
                Veil.LOGGER.error("Failed to replace vanilla shader '{}' with veil shader: Malformed name", pair.getFirst().method_35787());
                continue;
            }

            List<ShaderModification> modifiers = modificationManager.getModifiers(loc.method_45138("shaders/core/"));
            if (modifiers.size() == 1 && modifiers.getFirst() instanceof ReplaceShaderModification replaceModification) {
                ShaderProgram shader = renderer.getShaderManager().getShader(replaceModification.veilShader());
                if (shader != null) {
                    pair.getSecond().accept(VeilRenderBridge.toShaderInstance(shader));
                    continue;
                }

                Veil.LOGGER.error("Failed to replace vanilla shader '{}' with veil shader: {}", loc, replaceModification.veilShader());
            }
        }
    }
}
