/*
 * Decompiled with CFR 0.152.
 */
package xyz.volcanobay.pavloviandogs.smartanimal;

import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1314;
import net.minecraft.class_1493;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5534;
import xyz.volcanobay.pavloviandogs.registries.Actions;
import xyz.volcanobay.pavloviandogs.registries.Events;
import xyz.volcanobay.pavloviandogs.smartaction.Action;
import xyz.volcanobay.pavloviandogs.smartevents.SmartEvent;
import xyz.volcanobay.pavloviandogs.smartevents.StringEvent;

public class AnimalBrain {
    private class_1493 wolf;
    public List<SmartEvent> smartEventList = new ArrayList<SmartEvent>();
    private Action lastAction;
    private int eventTimer;
    public int eventsThisSecond;
    private float avgEventsPerSecond;
    public HashMap<String, HashBiMap<Float, String>> neuralNetwork = new HashMap();
    public Action action;

    public AnimalBrain(class_1493 wolf) {
        this.wolf = wolf;
        this.fillBrain();
    }

    public void fillBrain() {
        for (String event : Events.events.keySet()) {
            if (this.neuralNetwork.containsKey(event)) continue;
            this.addNewEvent(event);
        }
        this.sortBrain();
    }

    public SmartEvent getMostRecentEvent() {
        if (!this.smartEventList.isEmpty()) {
            return this.smartEventList.get(this.smartEventList.size() - 1);
        }
        return null;
    }

    public void addNewEvent(String event) {
        this.neuralNetwork.put(event, (HashBiMap<Float, String>)HashBiMap.create((int)Actions.actions.size()));
        for (String action : Actions.actions.keySet()) {
            this.neuralNetwork.get(event).put((Object)Float.valueOf((float)Math.random()), (Object)action);
        }
    }

    public void tick() {
        if (this.wolf.method_35057() == null) {
            if (!this.wolf.method_5942().method_23966()) {
                class_243 goal = null;
                if (this.wolf.method_5816()) {
                    class_243 vec3 = class_5534.method_31527((class_1314)this.wolf, (int)15, (int)7);
                    goal = vec3 == null ? this.wolf.method_19538() : vec3;
                } else {
                    class_243 class_2432 = goal = this.wolf.method_59922().method_43057() >= 0.99f ? class_5534.method_31527((class_1314)this.wolf, (int)10, (int)7) : this.wolf.method_19538();
                }
                if (goal != null) {
                    this.wolf.method_5942().method_6337(goal.field_1352, goal.field_1351, goal.field_1350, 1.0);
                    this.wolf.method_6179(false);
                }
            }
            return;
        }
        ++this.eventTimer;
        ArrayList<SmartEvent> forgottenMemories = new ArrayList<SmartEvent>();
        for (SmartEvent smartEvent : this.smartEventList) {
            ++smartEvent.age;
            if (smartEvent.age > smartEvent.getMemoryLength()) {
                forgottenMemories.add(smartEvent);
            }
            smartEvent.tick(this.wolf);
        }
        if (this.eventTimer > 20) {
            this.avgEventsPerSecond = (this.avgEventsPerSecond + (float)this.eventsThisSecond) / 2.0f;
            this.eventsThisSecond = 0;
            this.eventTimer = 0;
        }
        this.smartEventList.removeAll(forgottenMemories);
    }

    public void addSmartEvent(SmartEvent smartEvent) {
        this.smartEventList.add(smartEvent);
        ++this.eventsThisSecond;
        float strongestWeight = ((Float)this.neuralNetwork.get(smartEvent.getReference()).keySet().toArray()[this.neuralNetwork.get(smartEvent.getReference()).size() - 1]).floatValue();
        this.pickAction(smartEvent);
    }

    public void pickAction(SmartEvent event) {
        Action pickedAction = null;
        while (pickedAction == null) {
            int step = (int)Math.ceil(Math.sqrt(Math.random()) * (double)this.neuralNetwork.get(event.getReference()).size() - 1.0);
            float weight = ((Float)this.neuralNetwork.get(event.getReference()).keySet().toArray()[step]).floatValue();
            String[] text = new String[]{};
            if (event instanceof StringEvent) {
                StringEvent stringEvent = (StringEvent)event;
                text = stringEvent.storedString;
            }
            if (!((double)weight > Math.random())) continue;
            pickedAction = Actions.actions.get(this.neuralNetwork.get(event.getReference()).get((Object)Float.valueOf(weight))).apply(text);
        }
        this.updateAction(pickedAction, event.pos);
    }

    public void updateAction(Action action, class_2338 pos) {
        action.setPos(pos);
        this.action = action;
        this.lastAction = action;
    }

    public void stopAction() {
        this.action = null;
    }

    public void sortBrain() {
        for (String event : this.neuralNetwork.keySet()) {
            List weights = this.neuralNetwork.get(event).keySet().stream().sorted().toList();
            HashBiMap oldMap = HashBiMap.create((Map)((Map)this.neuralNetwork.get(event)));
            this.neuralNetwork.get(event).clear();
            Iterator iterator = weights.iterator();
            while (iterator.hasNext()) {
                float f = ((Float)iterator.next()).floatValue();
                this.neuralNetwork.get(event).put((Object)Float.valueOf(f), (Object)((String)oldMap.get((Object)Float.valueOf(f))));
            }
        }
    }

    public void sendPhrase(String text) {
    }

    public void encourage(float amount, SmartEvent event, String action) {
        if (event != null) {
            float oldValue = ((Float)this.neuralNetwork.get(event.getReference()).inverse().get((Object)action)).floatValue();
            float newValue = class_3532.method_15363((float)(oldValue + amount / 20.0f), (float)0.0f, (float)1.0f);
            if (this.neuralNetwork.get(event.getReference()).containsKey((Object)Float.valueOf(newValue))) {
                String actionString = (String)this.neuralNetwork.get(event.getReference()).get((Object)Float.valueOf(newValue));
                this.neuralNetwork.get(event.getReference()).remove((Object)Float.valueOf(newValue));
                this.neuralNetwork.get(event.getReference()).put((Object)Float.valueOf(oldValue), (Object)actionString);
            } else {
                this.neuralNetwork.get(event.getReference()).remove((Object)Float.valueOf(oldValue));
            }
            this.neuralNetwork.get(event.getReference()).put((Object)Float.valueOf(newValue), (Object)action);
            this.sortBrain();
        }
    }

    public void encourage(float amount) {
        if (this.lastAction == null) {
            return;
        }
        SmartEvent lastEvent = this.getMostRecentEvent();
        if (lastEvent == null) {
            return;
        }
        this.encourage(amount, lastEvent, this.lastAction.reference);
        for (String string : new ArrayList(this.neuralNetwork.get(lastEvent.getReference()).values())) {
            if (string == this.lastAction.reference) continue;
            this.discourage(0.05f, lastEvent, string);
        }
    }

    public void discourage(float amount, SmartEvent event, String action) {
        if (event != null) {
            float oldValue = ((Float)this.neuralNetwork.get(event.getReference()).inverse().get((Object)action)).floatValue();
            float newValue = Math.min(1.0f, oldValue - amount / 20.0f);
            if (this.neuralNetwork.get(event.getReference()).containsKey((Object)Float.valueOf(newValue))) {
                String actionString = (String)this.neuralNetwork.get(event.getReference()).get((Object)Float.valueOf(newValue));
                this.neuralNetwork.get(event.getReference()).remove((Object)Float.valueOf(newValue));
                this.neuralNetwork.get(event.getReference()).put((Object)Float.valueOf(oldValue), (Object)actionString);
            } else {
                this.neuralNetwork.get(event.getReference()).remove((Object)Float.valueOf(oldValue));
            }
            this.neuralNetwork.get(event.getReference()).put((Object)Float.valueOf(newValue), (Object)action);
            this.sortBrain();
        }
    }

    public void discourage(float amount) {
        if (this.lastAction == null) {
            return;
        }
        SmartEvent lastEvent = this.getMostRecentEvent();
        if (lastEvent == null) {
            return;
        }
        this.discourage(amount, lastEvent, this.lastAction.reference);
        for (String string : new ArrayList(this.neuralNetwork.get(lastEvent.getReference()).values())) {
            if (string == this.lastAction.reference) continue;
            this.encourage(0.05f, lastEvent, string);
        }
    }
}

