package org.dystoria.tweaks.battle;

import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;
import net.minecraft.class_8646;
import net.minecraft.class_9013;
import net.minecraft.class_9025;
import net.minecraft.class_9779;

public class BattleHud {
    private static final char ALIVE = 'A';
    private static final char STATUS ='S';
    private static final char DEAD = 'D';

    private static final class_2960 ALIVE_ICON = class_2960.method_60655("dystorian-extras", "textures/font/alive.png");
    private static final class_2960 STATUS_ICON = class_2960.method_60655("dystorian-extras", "textures/font/status.png");
    private static final class_2960 FAINTED_ICON = class_2960.method_60655("dystorian-extras", "textures/font/dead.png");

    private static final int ICON_LENGTH = 16;

    public static void hudCallback (class_332 context, class_9779 counter) {
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle != null && class_310.method_1551().field_1724 != null && class_310.method_1498()) {
            ClientBattleSide left = battle.getSide1().getActors().stream().anyMatch(actor -> actor.getUuid().equals(class_310.method_1551().field_1724.method_5667())) ? battle.getSide1() : battle.getSide2();
            ClientBattleSide right = left == battle.getSide1() ? battle.getSide2() : battle.getSide1();

            renderSide(context, left, true);
            renderSide(context, right, false);
        }
    }

    private static void renderSide (class_332 context, ClientBattleSide side, boolean isLeft) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) return;

        StringBuilder team = new StringBuilder();

        for (ClientBattleActor actor : side.getActors()) {
            if (actor.getType() != ActorType.PLAYER) continue;
            class_1657 player = world.method_18470(actor.getUuid());
            if (player == null) continue;

            class_269 scoreboard = player.method_7327();
            class_266 teamScoreboard = scoreboard.method_1189(class_8646.field_45158);
            if (teamScoreboard == null) continue;

            class_9013 readableScoreboardScore = scoreboard.method_55430(player, teamScoreboard);
            team.append(class_9013.method_55398(readableScoreboardScore, teamScoreboard.method_55380(class_9025.field_47566)).getString().strip());
        }

        List<class_2960> icons = new ArrayList<>();
        for (char icon : team.toString().toCharArray()) {
            if (icon == ALIVE) icons.add(ALIVE_ICON);
            else if (icon == STATUS) icons.add(STATUS_ICON);
            else if (icon == DEAD) icons.add(FAINTED_ICON);
        }

        int height = class_310.method_1551().method_22683().method_4502();
        int x = isLeft ? 2 : class_310.method_1551().method_22683().method_4486() - ICON_LENGTH - 2;
        for (int i = 0; i < icons.size(); ++i) {
            class_2960 icon = icons.get(i);
            int y = (height / 2) - (icons.size() * ICON_LENGTH / 2) + (i * (ICON_LENGTH + 1));

            context.method_25290(icon, x, y, 0, 0, ICON_LENGTH, ICON_LENGTH, ICON_LENGTH, ICON_LENGTH);
        }
    }
}
