package org.dystoria.tweaks.gui;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.gui.summary.Summary;
import com.cobblemon.mod.common.pokemon.Pokemon;
import org.dystoria.tweaks.DystoriaTweaksClient;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public final class ShinyIcons {
    private static final class_2960 SHINIER = DystoriaTweaksClient.identifier("textures/gui/shiny/shinier.png");
    private static final class_2960 SHINIEST = DystoriaTweaksClient.identifier("textures/gui/shiny/shiniest.png");

    private static final List<class_2960> STARS = List.of(Summary.Companion.getIconShinyResource(), SHINIER, SHINIEST);

    private static class_2960 getStar (int tier) {
        if (tier < 0) return Summary.Companion.getIconShinyResource();
        if (tier >= STARS.size()) return STARS.getLast();
        return STARS.get(tier);
    }

    public static void placeExtraShinyIcons (@NotNull Pokemon pokemon, class_4587 matrices, double x, double y, int length, boolean leftToRight) {
        if (pokemon.getShiny()) {
            int shinyStars = 0;
            if (pokemon.getAspects().contains("shinier")) shinyStars = 1;
            if (pokemon.getAspects().contains("shiniest")) shinyStars = 2;

            int direction = leftToRight ? 1 : -1;
            for (int i = 1; i <= shinyStars; ++i) {
                GuiUtilsKt.blitk(
                    matrices,
                    ShinyIcons.getStar(i),
                    x + (length + 1) * i * direction, y,
                    length, length,
                    0, 0,
                    length, length,
                    0,
                    1, 1, 1,
                    1,
                    true,
                    0.5f
                );
            }
        }
    }
}
