package org.dystoria.tweaks.gui;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.pokemon.Pokemon;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.dystoria.tweaks.DystoriaTweaksClient;

public interface TeraIcons {
    int LENGTH = 22;

    static class_2960 getTeraIcon (String teraType) {
        return DystoriaTweaksClient.identifier("textures/gui/tera/" + teraType + ".png");
    }

    static void render (class_332 context, Pokemon pokemon, double x, double y, int mouseX, int mouseY) {
        class_2960 teraType = TeraIcons.getTeraIcon(pokemon.getTeraType().showdownId());

        context.method_51448().method_22903();
        context.method_51448().method_46416(0, 0, 3000);
        GuiUtilsKt.blitk(
            context.method_51448(),
            teraType,
            x, y,
            TeraIcons.LENGTH, TeraIcons.LENGTH,
            0, 0,
            TeraIcons.LENGTH, TeraIcons.LENGTH,
            0,
            1, 1, 1,
            1,
            true,
            0.5f
        );

        if (mouseX * 2f >= x && mouseX * 2f <= x + TeraIcons.LENGTH && mouseY * 2f >= y && mouseY * 2f <= y + TeraIcons.LENGTH) {
            char[] characters = pokemon.getTeraType().showdownId().toCharArray();
            if (characters.length > 0) characters[0] = Character.toUpperCase(characters[0]);
            context.method_51438(class_310.method_1551().field_1772, class_2561.method_43469("tooltip.dystoria-tweaks.tera", new String(characters)), mouseX, mouseY);
        }
        context.method_51448().method_22909();
    }
}
