package org.dystoria.tweaks.mixin;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.gui.pc.PCGUI;
import com.cobblemon.mod.common.pokemon.Pokemon;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.dystoria.tweaks.gui.ShinyIcons;
import org.dystoria.tweaks.gui.TeraIcons;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(PCGUI.class)
public abstract class PCGUIMixin extends class_437 {
    protected PCGUIMixin (class_2561 title) {
        super(title);
    }

    @Shadow private Pokemon previewPokemon;

    @Inject(method = "render", at = @At("TAIL"))
    private void addExtraIcons (class_332 context, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (this.previewPokemon != null) {
            int x = (super.field_22789 - 349) / 2;
            int y = (super.field_22790 - 205) / 2;

            ShinyIcons.placeExtraShinyIcons(
                this.previewPokemon,
                context.method_51448(),
                (x + 62.5) / 0.5,
                (y + 28.5) / 0.5,
                16,
                false
            );

            // Tera
            double teraX = (x + 61) / 0.5;
            double teraY = (y + 93.5) / 0.5;
            class_2960 teraType = TeraIcons.getTeraIcon(this.previewPokemon.getTeraType().showdownId());
            GuiUtilsKt.blitk(
                context.method_51448(),
                teraType,
                teraX, teraY,
                TeraIcons.LENGTH, TeraIcons.LENGTH,
                0, 0,
                TeraIcons.LENGTH, TeraIcons.LENGTH,
                0,
                1, 1, 1,
                1,
                true,
                0.5f
            );

            if (mouseX * 2f >= teraX && mouseX * 2f <= teraX + TeraIcons.LENGTH && mouseY * 2f >= teraY && mouseY * 2f <= teraY + TeraIcons.LENGTH) {
                char[] characters = this.previewPokemon.getTeraType().showdownId().toCharArray();
                if (characters.length > 0) characters[0] = Character.toUpperCase(characters[0]);
                context.method_51438(class_310.method_1551().field_1772, class_2561.method_43469("tooltip.dystoria-tweaks.tera", new String(characters)), mouseX, mouseY);
            }
        }
    }
}
