package org.dystoria.tweaks.mixin;

import com.cobblemon.mod.common.client.gui.summary.Summary;
import com.cobblemon.mod.common.pokemon.Pokemon;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.dystoria.tweaks.gui.ShinyIcons;
import org.dystoria.tweaks.gui.TeraIcons;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(Summary.class)
public abstract class SummaryMixin extends class_437 {
    protected SummaryMixin (class_2561 title) {
        super(title);
    }

    @Shadow
    private Pokemon selectedPokemon;

    @Inject(method = "render", at = @At("TAIL"))
    private void addSummaryIcons (class_332 context, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (this.selectedPokemon != null) {
            // Shiny Stars
            int x = (super.field_22789 - 331) / 2;
            int y = (super.field_22790 - 161) / 2;

            ShinyIcons.placeExtraShinyIcons(
                this.selectedPokemon,
                context.method_51448(),
                (x + 62.5) / 0.5,
                (y + 33.5) / 0.5,
                16,
                false
            );

            // Tera
            double teraX = (x + 6) / 0.5;
            double teraY = (y + 32) / 0.5;
            TeraIcons.render(context, this.selectedPokemon, teraX, teraY, mouseX, mouseY);
        }
    }
}
