package org.dystoria.tweaks.mixin;

import com.cobblemon.mod.common.client.gui.trade.TradeGUI;
import com.cobblemon.mod.common.pokemon.Pokemon;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.dystoria.tweaks.gui.ShinyIcons;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(TradeGUI.class)
public abstract class TradeGUIMixin extends class_437 {
    protected TradeGUIMixin (class_2561 title) {
        super(title);
    }

    @Inject(method = "renderPokemonInfo", at = @At("TAIL"))
    private void addShinierIcons (Pokemon pokemon, boolean isOpposing, class_332 context, int x, int y, int mouseX, int mouseY, CallbackInfo info) {
        if (pokemon == null) return;

        ShinyIcons.placeExtraShinyIcons(
            pokemon,
            context.method_51448(),
            (x + (isOpposing ? 213.5 : 71.5)) / 0.5,
            (y + 33.5) / 0.5,
            16,
            !isOpposing
        );
    }
}
