/*
 * Decompiled with CFR 0.152.
 */
package nieboczek.makelag.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import net.fabricmc.loader.api.FabricLoader;
import nieboczek.makelag.MakeLag;
import org.apache.commons.io.FileUtils;

public class Config {
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static String[] deathMessages;
    public static final String[] BUILT_IN_PROGRESSIONS;

    public static void setup() {
        File cfgDir = Config.getCfgDir();
        File deathMessagesFile = new File(cfgDir, "death_messages.json");
        File progressionsDir = new File(cfgDir, "progressions");
        cfgDir.mkdir();
        progressionsDir.mkdir();
        if (!deathMessagesFile.exists()) {
            URL input = MakeLag.class.getResource("/assets/death_messages.json");
            try {
                FileUtils.copyURLToFile((URL)input, (File)deathMessagesFile);
            }
            catch (IOException e) {
                MakeLag.log.error("[cfg] couldn't copy death_messages.json to config/makelag/death_messages.json");
            }
        }
        for (String builtInProgression : BUILT_IN_PROGRESSIONS) {
            File file = new File(progressionsDir, builtInProgression + ".json");
            if (file.exists()) continue;
            URL input = MakeLag.class.getResource("/assets/progressions/" + builtInProgression + ".json");
            try {
                FileUtils.copyURLToFile((URL)input, (File)file);
            }
            catch (IOException e) {
                MakeLag.log.error("[cfg] couldn't copy {}.json to config/makelag/progressions/{}.json", (Object)builtInProgression, (Object)builtInProgression);
            }
        }
    }

    public static void reload() {
        try {
            File cfgDir = Config.getCfgDir();
            File deathMessagesFile = new File(cfgDir, "death_messages.json");
            try (FileReader reader = new FileReader(deathMessagesFile);){
                deathMessages = (String[])gson.fromJson((Reader)reader, String[].class);
            }
            MakeLag.log.info("[cfg] reloaded successfully");
        }
        catch (IOException e) {
            MakeLag.log.error("[cfg] error while reloading: ", (Throwable)e);
        }
    }

    public static File getCfgDir() {
        return FabricLoader.getInstance().getConfigDir().resolve("makelag").toFile();
    }

    public static File getProgressionsDir() {
        return new File(Config.getCfgDir(), "progressions");
    }

    static {
        BUILT_IN_PROGRESSIONS = new String[]{"default", "null"};
    }
}

