/*
 * Decompiled with CFR 0.152.
 */
package nieboczek.makelag.module.backend;

import java.util.ArrayList;
import java.util.function.Consumer;
import nieboczek.makelag.module.backend.Key;
import nieboczek.makelag.module.backend.Module;

public final class ModuleState {
    private final ArrayList<StoredKey<?>> storedKeys = new ArrayList();
    public final Module module;

    public ModuleState(Module module) {
        this.module = module;
        module.getAllKeys().forEach((Consumer<Key<?>>)((Consumer<Key>)key -> this.storedKeys.add(new StoredKey(key))));
    }

    public <T> T get(Key<T> key) {
        return this.find(key).value;
    }

    public <T> void set(Key<T> key, T value) {
        this.find(key).value = value;
    }

    private <T> StoredKey<T> find(Key<T> key) {
        return this.storedKeys.stream().filter(stored -> stored.key == key).findFirst().orElseThrow();
    }

    private static final class StoredKey<T> {
        final Key<T> key;
        T value;

        private StoredKey(Key<T> key) {
            this.key = key;
            this.value = key.initialValue();
        }
    }
}

