/*
 * Decompiled with CFR 0.152.
 */
package nieboczek.makelag;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import nieboczek.makelag.MakeLag;
import nieboczek.makelag.config.Config;
import nieboczek.makelag.config.PlayerConfig;
import nieboczek.makelag.module.Modules;
import nieboczek.makelag.module.backend.Key;
import nieboczek.makelag.module.backend.Module;
import nieboczek.makelag.network.PingDisplayS2CPacket;
import nieboczek.makelag.progression.ProgressionManager;
import org.apache.commons.io.FilenameUtils;

public class Commands {
    public static final LiteralArgumentBuilder<class_2168> command = (LiteralArgumentBuilder)class_2170.method_9247((String)"makelag").requires((Predicate)class_2170.method_71774((int)2));
    private static final SuggestionProvider<class_2168> PROGRESSION_SUGGESTIONS = (context, builder) -> Commands.getFileSuggestionsWithoutExtensions(builder, new File(Config.getCfgDir(), "progressions"));

    private static void sendFeedback(CommandContext<class_2168> context, String msg) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a76MakeLag \u00a78>>\u00a7r " + msg)), true);
    }

    private static <T> int executeCommand(CommandContext<class_2168> context, String moduleName, Key<T> key) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        PlayerConfig config = MakeLag.getConfig(player);
        Object value = context.getArgument("value", key.clazz());
        config.states.stream().filter(state -> state.module.getId().equals(moduleName)).findFirst().orElseThrow().set(key, value);
        Commands.sendFeedback(context, "Set %s of %s for %s to %s".formatted(key.id(), moduleName, player.method_5477().getString(), value));
        return 0;
    }

    private static <T> int executeConfigCommand(CommandContext<class_2168> context, Key<T> key) {
        Object value = context.getArgument("value", key.clazz());
        MakeLag.configState.set(key, value);
        Commands.sendFeedback(context, "Set %s to %s".formatted(key.id(), value));
        return 0;
    }

    private static CompletableFuture<Suggestions> getFileSuggestionsWithoutExtensions(SuggestionsBuilder builder, File dir) {
        for (File file : dir.listFiles()) {
            builder.suggest(FilenameUtils.removeExtension((String)file.getName()));
        }
        return builder.buildFuture();
    }

    static {
        command.then(class_2170.method_9247((String)"start").executes(context -> {
            MakeLag.tickRate = 1;
            MakeLag.ticks = 0;
            Commands.sendFeedback((CommandContext<class_2168>)context, "Started making lag with progression " + ProgressionManager.loadedId);
            return 0;
        }));
        command.then(class_2170.method_9247((String)"togglePingDisplay").executes(context -> {
            MakeLag.pingDisplayed = !MakeLag.pingDisplayed;
            PingDisplayS2CPacket payload = new PingDisplayS2CPacket(MakeLag.pingDisplayed);
            for (class_3222 player : MakeLag.server.method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            }
            return 0;
        }));
        RequiredArgumentBuilder stateCmd = class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305());
        for (Module module : Modules.MODULES) {
            String moduleName = module.getId();
            LiteralArgumentBuilder moduleCmd = class_2170.method_9247((String)moduleName);
            for (Key<?> key : module.configurableKeys) {
                moduleCmd.then(class_2170.method_9247((String)key.id()).then(class_2170.method_9244((String)"value", key.argumentType()).executes(context -> Commands.executeCommand((CommandContext<class_2168>)context, moduleName, key))));
            }
            stateCmd.then((ArgumentBuilder)moduleCmd);
        }
        command.then(class_2170.method_9247((String)"state").then((ArgumentBuilder)stateCmd));
        LiteralArgumentBuilder configCmd = class_2170.method_9247((String)"config");
        for (Key key : Modules.CONFIG.configurableKeys) {
            configCmd.then(class_2170.method_9247((String)key.id()).then(class_2170.method_9244((String)"value", key.argumentType()).executes(context -> Commands.executeConfigCommand((CommandContext<class_2168>)context, key))));
        }
        command.then((ArgumentBuilder)configCmd);
        command.then(class_2170.method_9247((String)"reload").executes(context -> {
            boolean sameProgression;
            int oldHash = ProgressionManager.loadedProgressionHash;
            Object[] previousDeathMessages = (String[])Config.deathMessages.clone();
            ProgressionManager.load(ProgressionManager.loadedId);
            Config.reload();
            boolean sameDeathMessages = Arrays.equals(previousDeathMessages, Config.deathMessages);
            boolean bl = sameProgression = oldHash == ProgressionManager.loadedProgressionHash;
            if (sameDeathMessages && sameProgression) {
                Commands.sendFeedback((CommandContext<class_2168>)context, "Reloaded, nothing changed");
            } else if (sameDeathMessages) {
                Commands.sendFeedback((CommandContext<class_2168>)context, "Reloaded progression " + ProgressionManager.loadedId);
            } else if (sameProgression) {
                Commands.sendFeedback((CommandContext<class_2168>)context, "Reloaded death_messages.json");
            } else {
                Commands.sendFeedback((CommandContext<class_2168>)context, "Reloaded death_messages.json and progression " + ProgressionManager.loadedId);
            }
            return 0;
        }));
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"progression").then(class_2170.method_9247((String)"pause").executes(context -> {
            if (MakeLag.tickRate == 0) {
                Commands.sendFeedback((CommandContext<class_2168>)context, "Can't pause, making lag is already paused");
                return 1;
            }
            MakeLag.tickRate = 0;
            ProgressionManager.resetToDefaults();
            Commands.sendFeedback((CommandContext<class_2168>)context, "Paused making lag at tick " + MakeLag.ticks);
            return 0;
        }))).then(class_2170.method_9247((String)"resume").executes(context -> {
            if (MakeLag.tickRate > 0) {
                Commands.sendFeedback((CommandContext<class_2168>)context, "Can't resume, making lag is already resumed");
                return 1;
            }
            MakeLag.tickRate = 1;
            ProgressionManager.setTick(MakeLag.ticks);
            Commands.sendFeedback((CommandContext<class_2168>)context, "Resumed making lag at tick " + MakeLag.ticks);
            return 0;
        }))).then(class_2170.method_9247((String)"load").then(class_2170.method_9244((String)"progression", (ArgumentType)StringArgumentType.word()).suggests(PROGRESSION_SUGGESTIONS).executes(context -> {
            String id = (String)context.getArgument("progression", String.class);
            List<String> messages = ProgressionManager.load(id);
            for (String message : messages) {
                Commands.sendFeedback((CommandContext<class_2168>)context, message);
            }
            return 0;
        })))).then(class_2170.method_9247((String)"tick").then(class_2170.method_9244((String)"tick", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(context -> {
            MakeLag.ticks = (Integer)context.getArgument("tick", Integer.class);
            if (MakeLag.tickRate > 0) {
                ProgressionManager.setTick(MakeLag.ticks);
            }
            Commands.sendFeedback((CommandContext<class_2168>)context, "Set progression tick of " + ProgressionManager.loadedId + " to " + MakeLag.ticks);
            return 0;
        })))).then(class_2170.method_9247((String)"skip").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int skippedTicks = (Integer)context.getArgument("ticks", Integer.class);
            Commands.sendFeedback((CommandContext<class_2168>)context, "Skipped " + skippedTicks + " ticks of progression " + ProgressionManager.loadedId + ", progression tick is now " + (MakeLag.ticks += skippedTicks));
            return 0;
        })))).then(class_2170.method_9247((String)"tickRate").then(class_2170.method_9244((String)"rate", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            MakeLag.tickRate = (Integer)context.getArgument("rate", Integer.class);
            Commands.sendFeedback((CommandContext<class_2168>)context, "Set progression tick rate of " + ProgressionManager.loadedId + " to " + MakeLag.tickRate);
            return 0;
        }))));
    }
}

