/*
 * Decompiled with CFR 0.152.
 */
package nieboczek.makelag;

import io.netty.channel.ChannelHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import nieboczek.makelag.Commands;
import nieboczek.makelag.config.Config;
import nieboczek.makelag.config.PlayerConfig;
import nieboczek.makelag.module.Modules;
import nieboczek.makelag.module.backend.Module;
import nieboczek.makelag.module.backend.ModuleState;
import nieboczek.makelag.network.DelayedChannelHandler;
import nieboczek.makelag.network.PingDisplayS2CPacket;
import nieboczek.makelag.network.PingS2CPacket;
import nieboczek.makelag.progression.ProgressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeLag
implements ModInitializer {
    private static final int MIN_TICKS_UNTIL_NEW_POSITION = 1200;
    private static final int MAX_TICKS_UNTIL_NEW_POSITION = 2400;
    private static final int TICKS_UNTIL_PING_SEND = 40;
    public static final String MSG_PREFIX = "\u00a76MakeLag \u00a78>>\u00a7r ";
    public static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    public static final Logger log = LoggerFactory.getLogger((String)"MakeLag");
    public static final Map<UUID, PlayerConfig> playerConfigs = new LinkedHashMap<UUID, PlayerConfig>();
    public static final Random random = new Random();
    public static MinecraftServer server;
    public static ModuleState configState;
    public static ArrayList<class_243> positions;
    public static boolean pingDisplayed;
    public static int tickRate;
    public static int ticks;
    public int ticksUntilNewPosition = 1200;
    public int ticksUntilPingSend = 40;
    public static int droppedPackets;
    public static int modulesRan;
    public static int fakeLagSpikes;
    public static int lagSpikes;
    public static int ticksUntilSendStats;

    public static PlayerConfig getConfig(class_3222 player) {
        return playerConfigs.get(player.method_5667());
    }

    public static ModuleState getState(class_3222 player, Module module) {
        return MakeLag.getConfig(player).get(module);
    }

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((x, y, z) -> x.register(Commands.command));
        PayloadTypeRegistry.playS2C().register(PingS2CPacket.ID, PingS2CPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(PingDisplayS2CPacket.ID, PingDisplayS2CPacket.CODEC);
        ServerTickEvents.END_SERVER_TICK.register(this::serverTick);
        ServerPlayerEvents.JOIN.register(this::setupPlayer);
        UseBlockCallback.EVENT.register(this::useBlock);
        Config.setup();
        Config.reload();
        List<String> messages = ProgressionManager.load("default");
        if (messages.size() > 1) {
            log.error("error while loading progression default:");
            for (String message : messages) {
                log.error(message);
            }
        }
    }

    private void serverTick(MinecraftServer mcServer) {
        if (server == null) {
            server = mcServer;
        }
        this.sendPings();
        if (ticks < 0) {
            return;
        }
        ProgressionManager.tick(ticks);
        --ticksUntilSendStats;
        ticks += tickRate;
        this.addNewPosition();
        this.executeFakeLagSpike();
        this.runModules();
    }

    private void sendPings() {
        --this.ticksUntilPingSend;
        if (this.ticksUntilPingSend <= 0) {
            List players = server.method_3760().method_14571();
            for (class_3222 player : players) {
                ModuleState state = MakeLag.getState(player, Modules.PACKET);
                int delay = random.nextInt(state.get(Modules.PACKET.delay) - state.get(Modules.PACKET.delayDelta) + 20, state.get(Modules.PACKET.delay) + state.get(Modules.PACKET.delayDelta) + 31);
                PingS2CPacket payload = new PingS2CPacket(player.method_5477().getString(), delay);
                for (class_3222 recipient : players) {
                    ServerPlayNetworking.send((class_3222)recipient, (class_8710)payload);
                }
            }
            this.ticksUntilPingSend = random.nextInt(40, 60);
        }
    }

    private void addNewPosition() {
        --this.ticksUntilNewPosition;
        if (this.ticksUntilNewPosition == 0) {
            List players = server.method_3760().method_14571();
            if (!players.isEmpty()) {
                class_3222 player = (class_3222)players.get(random.nextInt(players.size()));
                if (positions.size() == 5) {
                    positions.removeFirst();
                }
                positions.add(player.method_19538());
            }
            this.ticksUntilNewPosition = random.nextInt(1200, 2400);
        }
    }

    private void executeFakeLagSpike() {
        if (random.nextFloat() < configState.get(Modules.CONFIG.fakeLagSpikeChance).floatValue()) {
            server.method_54833().method_54675(true);
            scheduler.schedule(() -> {
                server.method_40000(() -> {
                    server.method_54833().method_54675(false);
                    server.method_54833().method_54671(60.0f);
                });
                scheduler.schedule(() -> server.method_40000(() -> {
                    server.method_54833().method_54671(20.0f);
                    ++fakeLagSpikes;
                }), 1L, TimeUnit.SECONDS);
            }, 2L, TimeUnit.SECONDS);
        }
    }

    private void runModules() {
        for (class_3222 player : server.method_3760().method_14571()) {
            PlayerConfig config = MakeLag.getConfig(player);
            for (Module module : Modules.MODULES) {
                ModuleState state;
                boolean canRun = module.canRun(player, state = config.get(module)) && module.didRandomChanceSucceed(state, random);
                if (!canRun) continue;
                module.run(player, state);
                ++modulesRan;
            }
        }
    }

    private class_1269 useBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (world.field_9236 || !player.method_18276()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() instanceof class_1747) {
            ModuleState state = MakeLag.getState((class_3222)player, Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS);
            ArrayList<class_2338> positionsToDisappear = state.get(Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS.positionsToDisappear);
            if (positionsToDisappear.isEmpty() && random.nextFloat() >= ((Float)state.get(Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS.intensity)).floatValue()) {
                return class_1269.field_5811;
            }
            int blocksToStartTimer = state.get(Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS.blocksToStartTimer);
            class_2338 placedBlockPos = hitResult.method_17777().method_10093(hitResult.method_17780());
            if (!positionsToDisappear.isEmpty() && !positionsToDisappear.getLast().method_19771((class_2382)placedBlockPos, 32.0)) {
                positionsToDisappear.clear();
            }
            positionsToDisappear.add(placedBlockPos);
            if (!state.get(Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS.timerStarted).booleanValue() && positionsToDisappear.size() >= blocksToStartTimer) {
                int timerLength = random.nextInt(state.get(Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS.timerLength) - state.get(Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS.timerLengthDelta), state.get(Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS.timerLength) + state.get(Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS.timerLengthDelta) + 1);
                state.set(Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS.timerStarted, true);
                scheduler.schedule(() -> server.method_40000(() -> {
                    for (class_2338 pos : positionsToDisappear) {
                        world.method_8501(pos, class_2246.field_10124.method_9564());
                    }
                    state.set(Modules.DISAPPEAR_SHIFT_PLACED_BLOCKS.timerStarted, false);
                    positionsToDisappear.clear();
                    ++modulesRan;
                }), (long)timerLength, TimeUnit.MILLISECONDS);
            }
        }
        return class_1269.field_5811;
    }

    private void setupPlayer(class_3222 player) {
        if (playerConfigs.containsKey(player.method_5667())) {
            return;
        }
        PlayerConfig config = new PlayerConfig();
        playerConfigs.put(player.method_5667(), config);
        DelayedChannelHandler handler = new DelayedChannelHandler(player.field_13987);
        player.field_13987.field_45013.field_11651.pipeline().addBefore("packet_handler", "makelag", (ChannelHandler)handler);
        ModuleState state = config.get(Modules.PACKET);
        state.set(Modules.PACKET.handler, handler);
        if (pingDisplayed) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new PingDisplayS2CPacket(true));
        }
    }

    static {
        configState = new ModuleState(Modules.CONFIG);
        positions = new ArrayList();
        pingDisplayed = false;
        tickRate = 0;
        ticks = -1;
        droppedPackets = 0;
        modulesRan = 0;
        fakeLagSpikes = 0;
        lagSpikes = 0;
        ticksUntilSendStats = 1200;
    }
}

