/*
 * Decompiled with CFR 0.152.
 */
package nieboczek.makelag.progression;

import nieboczek.makelag.module.backend.Key;
import nieboczek.makelag.module.backend.Module;

public record Keyframe<T extends Number>(Module module, Key<T> key, int startTick, int endTick, double startValue, double endValue) {
    public boolean isActive(int tick) {
        return tick >= this.startTick && tick <= this.endTick;
    }

    public double getProgress(int tick) {
        if (tick <= this.startTick) {
            return 0.0;
        }
        if (tick >= this.endTick) {
            return 1.0;
        }
        return (double)(tick - this.startTick) / (double)(this.endTick - this.startTick);
    }

    public T getValue(int tick) {
        double progress = this.getProgress(tick);
        double value = this.startValue + (this.endValue - this.startValue) * progress;
        if (this.key.initialValue() instanceof Integer) {
            return (T)Integer.valueOf((int)Math.round(value));
        }
        if (this.key.initialValue() instanceof Float) {
            return (T)Float.valueOf((float)value);
        }
        if (this.key.initialValue() instanceof Double) {
            return (T)Double.valueOf(value);
        }
        throw new IllegalStateException("Unsupported keyframe type: " + String.valueOf(((Number)this.key.initialValue()).getClass()));
    }
}

