/*
 * Decompiled with CFR 0.152.
 */
package nieboczek.makelag.progression;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import nieboczek.makelag.MakeLag;
import nieboczek.makelag.config.Config;
import nieboczek.makelag.config.PlayerConfig;
import nieboczek.makelag.module.Modules;
import nieboczek.makelag.module.backend.Key;
import nieboczek.makelag.module.backend.Module;
import nieboczek.makelag.module.backend.ModuleState;
import nieboczek.makelag.progression.Keyframe;
import nieboczek.makelag.progression.SerializedProgression;
import org.apache.commons.io.FilenameUtils;

public class ProgressionManager {
    public static final List<Keyframe<?>> timeline = new ArrayList();
    public static int loadedProgressionHash;
    public static String loadedId;

    public static List<String> load(String id) {
        File[] files = Config.getProgressionsDir().listFiles();
        if (files == null) {
            return List.of("Couldn't load progression:", "Wasn't able to get files in directory config/makelag/progressions");
        }
        for (File file : files) {
            List<String> list;
            if (!id.equals(FilenameUtils.removeExtension((String)file.getName()))) continue;
            FileReader reader = new FileReader(file);
            try {
                SerializedProgression progression = (SerializedProgression)Config.gson.fromJson((Reader)reader, SerializedProgression.class);
                list = ProgressionManager.deserializeProgression(progression, id, file.hashCode());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return List.of("Couldn't load progression:", "An error occurred while trying to read " + file.getName(), e.toString());
                }
                catch (JsonParseException e) {
                    return List.of("Couldn't load progression:", "An error occurred while trying to parse json from " + file.getName(), e.toString());
                }
            }
            reader.close();
            return list;
        }
        return List.of("Couldn't load progression:", "Didn't find a progression with id " + id);
    }

    private static List<String> deserializeProgression(SerializedProgression progression, String id, int hash) {
        for (SerializedProgression.SerializedKeyframe serializedFrame : progression.timeline()) {
            Module module = ProgressionManager.moduleFromStr(serializedFrame.module());
            if (module == null) {
                return List.of("Couldn't load progression:", "Didn't find a module with id " + serializedFrame.module());
            }
            Key<? extends Number> key = ProgressionManager.keyFromStr(module, serializedFrame.key());
            if (key == null) {
                return List.of("Couldn't load progression:", "Didn't find a key with id " + serializedFrame.key() + " in module " + serializedFrame.module());
            }
            timeline.add(new Keyframe<Number>(module, key, serializedFrame.startTick(), serializedFrame.endTick(), serializedFrame.startValue(), serializedFrame.endValue()));
        }
        timeline.sort(Comparator.comparingLong(Keyframe::startTick));
        loadedProgressionHash = hash;
        loadedId = id;
        return List.of("Loaded progression " + loadedId);
    }

    public static void tick(int currentTick) {
        for (Module module : Modules.MODULES) {
            ArrayList<ModuleState> states = new ArrayList<ModuleState>();
            for (PlayerConfig config : MakeLag.playerConfigs.values()) {
                states.add(config.get(module));
            }
            ProgressionManager.processFrames(currentTick, states, module);
        }
        ProgressionManager.processFrames(currentTick, List.of(MakeLag.configState), Modules.CONFIG);
    }

    public static void resetToDefaults() {
        for (Module module : Modules.MODULES) {
            for (PlayerConfig config : MakeLag.playerConfigs.values()) {
                ModuleState state = config.get(module);
                for (Key<?> key : module.configurableKeys) {
                    state.set(key, key.initialValue());
                }
            }
        }
    }

    public static void setTick(int tick) {
        ProgressionManager.resetToDefaults();
        for (Module module : Modules.MODULES) {
            ArrayList<ModuleState> states = new ArrayList<ModuleState>();
            for (PlayerConfig playerConfig : MakeLag.playerConfigs.values()) {
                states.add(playerConfig.get(module));
            }
            for (Keyframe keyframe : timeline) {
                Object valueToApply;
                if (keyframe.module() != module) continue;
                if (keyframe.isActive(tick)) {
                    valueToApply = keyframe.getValue(tick);
                } else {
                    if (tick <= keyframe.endTick()) continue;
                    valueToApply = keyframe.getValue(keyframe.endTick());
                }
                for (ModuleState state : states) {
                    state.set(keyframe.key(), valueToApply);
                }
            }
        }
    }

    private static Key<? extends Number> keyFromStr(Module module, String str) {
        for (Key<?> key : module.configurableKeys) {
            if (!str.equals(key.id())) continue;
            return key;
        }
        return null;
    }

    private static Module moduleFromStr(String str) {
        if (str.equals("config")) {
            return Modules.CONFIG;
        }
        for (Module module : Modules.MODULES) {
            if (!module.getId().equals(str)) continue;
            return module;
        }
        return null;
    }

    private static void processFrames(int currentTick, List<ModuleState> states, Module module) {
        for (Keyframe<?> frame : timeline) {
            if (frame.module() != module || !frame.isActive(currentTick)) continue;
            Object newValue = frame.getValue(currentTick);
            for (ModuleState state : states) {
                state.set(frame.key(), newValue);
            }
        }
    }

    static {
        loadedId = "null";
    }
}

