/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.item.armor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.rogues.item.Group;
import net.rogues.item.armor.RogueArmor;
import net.rogues.item.armor.WarriorArmor;
import net.rogues.util.RogueSounds;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;

public class RogueArmors {
    public static Holder<ArmorMaterial> material_rogue_t1 = RogueArmors.material("rogue_armor", 1, 3, 3, 1, 9, RogueSounds.ROGUE_ARMOR_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER}));
    public static Holder<ArmorMaterial> material_rogue_t2 = RogueArmors.material("assassin_armor", 2, 4, 4, 2, 10, RogueSounds.ROGUE_ARMOR_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT_HIDE}));
    public static Holder<ArmorMaterial> material_rogue_t3 = RogueArmors.material("netherite_assassin_armor", 2, 4, 4, 2, 15, RogueSounds.ROGUE_ARMOR_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> material_warrior_t1 = RogueArmors.material("warrior_armor", 2, 5, 4, 1, 9, RogueSounds.WARRIOR_ARMOR_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}));
    public static Holder<ArmorMaterial> material_warrior_t2 = RogueArmors.material("berserker_armor", 3, 8, 6, 2, 10, RogueSounds.WARRIOR_ARMOR_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}));
    public static Holder<ArmorMaterial> material_warrior_t3 = RogueArmors.material("netherite_berserker_armor", 3, 8, 6, 2, 15, RogueSounds.WARRIOR_ARMOR_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static final ArrayList<Armor.Entry> entries = new ArrayList();
    private static final ResourceLocation ATTACK_DAMAGE_ID = ResourceLocation.withDefaultNamespace((String)"generic.attack_damage");
    private static final ResourceLocation ATTACK_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"generic.attack_speed");
    private static final ResourceLocation KNOCKBACK_ID = ResourceLocation.withDefaultNamespace((String)"generic.knockback_resistance");
    private static final ResourceLocation MOVEMENT_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"generic.movement_speed");
    private static final ResourceLocation ARMOR_TOUGHNESS_ID = ResourceLocation.withDefaultNamespace((String)"generic.armor_toughness");
    public static final float rogue_t1_evasion = 0.03f;
    public static final float rogue_t1_haste = 0.04f;
    public static final float rogue_t2_evasion = 0.04f;
    public static final float rogue_t2_haste = 0.05f;
    public static final float rogue_t2_damage = 0.02f;
    public static final float rogue_t3_evasion = 0.05f;
    public static final float rogue_t3_haste = 0.05f;
    public static final float rogue_t3_damage = 0.05f;
    public static final float warrior_t1_damage = 0.04f;
    public static final float warrior_t2_damage = 0.05f;
    public static final float warrior_t2_knockback = 0.1f;
    public static final float warrior_t3_damage = 0.05f;
    public static final float warrior_t3_toughness = 1.0f;
    public static final float warrior_t3_knockback = 0.1f;
    public static final Armor.Set RogueArmorSet_t1 = RogueArmors.create(material_rogue_t1, ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"rogue_armor"), 15, RogueArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(RogueArmors.evasionBonus(0.03f)).add(RogueArmors.hasteMultiplier(0.04f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(RogueArmors.evasionBonus(0.03f)).add(RogueArmors.hasteMultiplier(0.04f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(RogueArmors.evasionBonus(0.03f)).add(RogueArmors.hasteMultiplier(0.04f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(RogueArmors.evasionBonus(0.03f)).add(RogueArmors.hasteMultiplier(0.04f))), 1).armorSet();
    public static final Armor.Set RogueArmorSet_t2 = RogueArmors.create(material_rogue_t2, ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"assassin_armor"), 25, RogueArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(RogueArmors.evasionBonus(0.04f)).add(RogueArmors.hasteMultiplier(0.05f)).add(RogueArmors.damageMultiplier(0.02f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(RogueArmors.evasionBonus(0.04f)).add(RogueArmors.hasteMultiplier(0.05f)).add(RogueArmors.damageMultiplier(0.02f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(RogueArmors.evasionBonus(0.04f)).add(RogueArmors.hasteMultiplier(0.05f)).add(RogueArmors.damageMultiplier(0.02f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(RogueArmors.evasionBonus(0.04f)).add(RogueArmors.hasteMultiplier(0.05f)).add(RogueArmors.damageMultiplier(0.02f))), 2).armorSet();
    public static final Armor.Set RogueArmorSet_t3 = RogueArmors.create(material_rogue_t3, ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"netherite_assassin_armor"), 37, RogueArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(RogueArmors.evasionBonus(0.05f)).add(RogueArmors.hasteMultiplier(0.05f)).add(RogueArmors.damageMultiplier(0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(RogueArmors.evasionBonus(0.05f)).add(RogueArmors.hasteMultiplier(0.05f)).add(RogueArmors.damageMultiplier(0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(RogueArmors.evasionBonus(0.05f)).add(RogueArmors.hasteMultiplier(0.05f)).add(RogueArmors.damageMultiplier(0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(RogueArmors.evasionBonus(0.05f)).add(RogueArmors.hasteMultiplier(0.05f)).add(RogueArmors.damageMultiplier(0.05f))), 3).armorSet();
    public static final Armor.Set WarriorArmorSet_t1 = RogueArmors.create(material_warrior_t1, ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"warrior_armor"), 15, WarriorArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(RogueArmors.damageMultiplier(0.04f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(5).add(RogueArmors.damageMultiplier(0.04f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(RogueArmors.damageMultiplier(0.04f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(RogueArmors.damageMultiplier(0.04f))), 1).armorSet();
    public static final Armor.Set WarriorArmorSet_t2 = RogueArmors.create(material_warrior_t2, ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"berserker_armor"), 25, WarriorArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(RogueArmors.damageMultiplier(0.05f)).add(RogueArmors.knockbackBonus(0.1f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(8).add(RogueArmors.damageMultiplier(0.05f)).add(RogueArmors.knockbackBonus(0.1f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(6).add(RogueArmors.damageMultiplier(0.05f)).add(RogueArmors.knockbackBonus(0.1f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(RogueArmors.damageMultiplier(0.05f)).add(RogueArmors.knockbackBonus(0.1f))), 2).armorSet();
    public static final Armor.Set WarriorArmorSet_t3 = RogueArmors.create(material_warrior_t3, ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"netherite_berserker_armor"), 37, WarriorArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(RogueArmors.damageMultiplier(0.05f)).add(RogueArmors.toughnessBonus(1.0f)).add(RogueArmors.knockbackBonus(0.1f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(8).add(RogueArmors.damageMultiplier(0.05f)).add(RogueArmors.toughnessBonus(1.0f)).add(RogueArmors.knockbackBonus(0.1f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(6).add(RogueArmors.damageMultiplier(0.05f)).add(RogueArmors.toughnessBonus(1.0f)).add(RogueArmors.knockbackBonus(0.1f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(RogueArmors.damageMultiplier(0.05f)).add(RogueArmors.toughnessBonus(1.0f)).add(RogueArmors.knockbackBonus(0.1f))), 3).armorSet();

    public static Holder<ArmorMaterial> material(String name, int protectionHead, int protectionChest, int protectionLegs, int protectionFeet, int enchantability, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient) {
        ArmorMaterial material = new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, protectionHead, ArmorItem.Type.CHESTPLATE, protectionChest, ArmorItem.Type.LEGGINGS, protectionLegs, ArmorItem.Type.BOOTS, protectionFeet), enchantability, equipSound, repairIngredient, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)name))), 0.0f, 0.0f);
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)name), (Object)material);
    }

    private static Armor.Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, Armor.Set.ItemFactory factory, ArmorSetConfig defaults, int tier) {
        Armor.Entry entry = Armor.Entry.create(material, (ResourceLocation)id, (int)durability, (Armor.Set.ItemFactory)factory, (ArmorSetConfig)defaults, (Equipment.LootProperties)Equipment.LootProperties.of((int)tier));
        entries.add(entry);
        return entry;
    }

    private static AttributeModifier damageMultiplier(float value) {
        return new AttributeModifier(ATTACK_DAMAGE_ID.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier hasteMultiplier(float value) {
        return new AttributeModifier(ATTACK_SPEED_ID.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier knockbackBonus(float value) {
        return new AttributeModifier(KNOCKBACK_ID.toString(), value, AttributeModifier.Operation.ADD_VALUE);
    }

    private static AttributeModifier movementSpeed(float value) {
        return new AttributeModifier(MOVEMENT_SPEED_ID.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier evasionBonus(float value) {
        return new AttributeModifier(SpellEngineAttributes.EVASION_CHANCE.id.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier toughnessBonus(float value) {
        return new AttributeModifier(ARMOR_TOUGHNESS_ID.toString(), value, AttributeModifier.Operation.ADD_VALUE);
    }

    public static void register(Map<String, ArmorSetConfig> configs) {
        Armor.register(configs, entries, Group.KEY);
    }
}

