/*
 * Decompiled with CFR 0.152.
 */
package net.rogues;

import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.rogues.block.CustomBlocks;
import net.rogues.config.Default;
import net.rogues.config.TweaksConfig;
import net.rogues.effect.RogueEffects;
import net.rogues.item.Books;
import net.rogues.item.Group;
import net.rogues.item.RogueWeapons;
import net.rogues.item.armor.RogueArmors;
import net.rogues.util.RogueSounds;
import net.rogues.village.RogueVillagers;
import net.spell_engine.api.config.ConfigFile;
import net.tiny_config.ConfigManager;

public class RoguesMod {
    public static final String NAMESPACE = "rogues";
    public static final String ID = "rogues";
    public static ConfigManager<ConfigFile.Equipment> itemConfig = new ConfigManager("equipment_v2", (Object)Default.itemConfig).builder().setDirectory("rogues").sanitize(true).build();
    public static ConfigManager<ConfigFile.Effects> effectsConfig = new ConfigManager("effects", (Object)new ConfigFile.Effects()).builder().setDirectory("rogues").sanitize(true).build();
    public static ConfigManager<StructurePoolConfig> villagesConfig = new ConfigManager("villages", (Object)Default.villages).builder().setDirectory("rogues").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks", (Object)new TweaksConfig()).builder().setDirectory("rogues").sanitize(true).build();

    public static void init() {
        tweaksConfig.refresh();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ((TweaksConfig)RoguesMod.tweaksConfig.value).ignore_items_required_mods = true;
        }
        itemConfig.refresh();
        effectsConfig.refresh();
        villagesConfig.refresh();
        if (((TweaksConfig)RoguesMod.tweaksConfig.value).rebalance_strength_attack_damage_multiplier > 0.0) {
            ((MobEffect)MobEffects.DAMAGE_BOOST.value()).addAttributeModifier(Attributes.ATTACK_DAMAGE, ResourceLocation.withDefaultNamespace((String)"strength"), ((TweaksConfig)RoguesMod.tweaksConfig.value).rebalance_strength_attack_damage_multiplier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        }
    }

    public static void registerSounds() {
        RogueSounds.register();
    }

    public static void registerItems() {
        Group.ROGUES = FabricItemGroup.builder().icon(() -> new ItemStack((ItemLike)RogueArmors.RogueArmorSet_t2.head)).title((Component)Component.translatable((String)"itemGroup.rogues.general")).build();
        CustomBlocks.register();
        Books.register();
        Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, Group.KEY, (Object)Group.ROGUES);
        RogueWeapons.register(((ConfigFile.Equipment)RoguesMod.itemConfig.value).weapons);
        RogueArmors.register(((ConfigFile.Equipment)RoguesMod.itemConfig.value).armor_sets);
        itemConfig.save();
    }

    public static void registerEffects() {
        RogueEffects.register((ConfigFile.Effects)RoguesMod.effectsConfig.value);
        effectsConfig.save();
    }

    public static void registerPOI() {
        RogueVillagers.registerPOI();
    }

    public static void registerVillagers() {
        RogueVillagers.registerVillagers();
    }
}

