/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.client;

import java.util.function.Supplier;
import mod.azure.azurelibarmor.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelibarmor.rewrite.render.armor.AzArmorRendererRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.rogues.client.armor.RogueArmorRenderer;
import net.rogues.client.armor.WarriorArmorRenderer;
import net.rogues.client.effect.ChargeParticles;
import net.rogues.client.effect.DemoralizeParticles;
import net.rogues.client.effect.ShatterParticles;
import net.rogues.effect.RogueEffects;
import net.rogues.item.armor.RogueArmors;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.render.StunParticleSpawner;
import net.spell_engine.client.gui.SpellTooltip;

public class RoguesClientMod {
    public static void init() {
        CustomParticleStatusEffect.register((MobEffect)RogueEffects.SHOCK.effect, (CustomParticleStatusEffect.Spawner)new StunParticleSpawner());
        CustomParticleStatusEffect.register((MobEffect)RogueEffects.SHATTER.effect, (CustomParticleStatusEffect.Spawner)new ShatterParticles(1));
        CustomParticleStatusEffect.register((MobEffect)RogueEffects.DEMORALIZE.effect, (CustomParticleStatusEffect.Spawner)new DemoralizeParticles(1));
        CustomParticleStatusEffect.register((MobEffect)RogueEffects.CHARGE.effect, (CustomParticleStatusEffect.Spawner)new ChargeParticles(1));
        SpellTooltip.addDescriptionMutator((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"throw"), args -> {
            String description = args.description();
            String percent = SpellTooltip.percent((float)(-1.0f * RogueEffects.SHATTER.config().firstModifier().value));
            description = description.replace(SpellTooltip.placeholder((String)"armor_reduction"), percent);
            return description;
        });
        SpellTooltip.addDescriptionMutator((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"shout"), args -> {
            String description = args.description();
            String percent = SpellTooltip.percent((float)(-1.0f * RogueEffects.DEMORALIZE.config().firstModifier().value));
            description = description.replace(SpellTooltip.placeholder((String)"damage_reduction"), percent);
            return description;
        });
        RoguesClientMod.registerArmorRenderer(RogueArmors.RogueArmorSet_t1, RogueArmorRenderer::rogue);
        RoguesClientMod.registerArmorRenderer(RogueArmors.RogueArmorSet_t2, RogueArmorRenderer::assassin);
        RoguesClientMod.registerArmorRenderer(RogueArmors.RogueArmorSet_t3, RogueArmorRenderer::netheriteAssassin);
        RoguesClientMod.registerArmorRenderer(RogueArmors.WarriorArmorSet_t1, WarriorArmorRenderer::warrior);
        RoguesClientMod.registerArmorRenderer(RogueArmors.WarriorArmorSet_t2, WarriorArmorRenderer::berserker);
        RoguesClientMod.registerArmorRenderer(RogueArmors.WarriorArmorSet_t3, WarriorArmorRenderer::netheriteBerserker);
    }

    private static void registerArmorRenderer(Armor.Set set, Supplier<AzArmorRenderer> armorRendererSupplier) {
        AzArmorRendererRegistry.register(armorRendererSupplier, (Item)set.head, (Item[])new Item[]{set.chest, set.legs, set.feet});
    }
}

