/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ntf.PinnedNoteManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class PlayerNoteStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"nts");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path NOTES_FILE = FabricLoader.getInstance().getConfigDir().resolve("ntf_player_notes.json");
    private static Map<String, String> playerNotes = new HashMap<String, String>();
    private static Set<String> favouritePlayers = new HashSet<String>();

    public static void saveNote(String playerName, String note) {
        if (note == null || note.trim().isEmpty()) {
            playerNotes.remove(playerName);
        } else {
            playerNotes.put(playerName, note.trim());
        }
        PlayerNoteStorage.saveNotes();
    }

    public static String getNote(String playerName) {
        return playerNotes.get(playerName);
    }

    public static boolean hasNote(String playerName) {
        return playerNotes.containsKey(playerName);
    }

    public static void removeNote(String playerName) {
        playerNotes.remove(playerName);
        favouritePlayers.remove(playerName);
        PlayerNoteStorage.saveNotes();
    }

    public static void addFavourite(String playerName) {
        favouritePlayers.add(playerName);
        PlayerNoteStorage.saveNotes();
    }

    public static void removeFavourite(String playerName) {
        favouritePlayers.remove(playerName);
        PlayerNoteStorage.saveNotes();
    }

    public static boolean isFavourite(String playerName) {
        return favouritePlayers.contains(playerName);
    }

    public static Set<String> getFavourites() {
        return new HashSet<String>(favouritePlayers);
    }

    public static void savePinnedPlayer(String player) {
        PlayerNoteStorage.saveNotes();
    }

    private static void loadNotes() {
        if (!Files.exists(NOTES_FILE, new LinkOption[0])) {
            LOGGER.info("Notes file not found, skipping load.");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(NOTES_FILE);){
            StorageData data = (StorageData)GSON.fromJson((Reader)reader, StorageData.class);
            if (data != null) {
                playerNotes = data.notes != null ? data.notes : new HashMap<String, String>();
                favouritePlayers = data.favourites != null ? data.favourites : new HashSet<String>();
                PinnedNoteManager.loadPinnedState(data.pinnedPlayer);
                LOGGER.info("Successfully loaded player notes, favourites, and pinned state!");
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load player notes: ", (Throwable)e);
        }
    }

    private static void saveNotes() {
        try {
            Files.createDirectories(NOTES_FILE.getParent(), new FileAttribute[0]);
            StorageData data = new StorageData();
            data.notes = playerNotes;
            data.favourites = favouritePlayers;
            data.pinnedPlayer = PinnedNoteManager.getPinnedPlayer();
            try (BufferedWriter writer = Files.newBufferedWriter(NOTES_FILE, new OpenOption[0]);){
                GSON.toJson((Object)data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save player notes: ", (Throwable)e);
        }
    }

    public static Map<String, String> getAllNotes() {
        return new HashMap<String, String>(playerNotes);
    }

    public static void clearAllNotes() {
        playerNotes.clear();
        favouritePlayers.clear();
        PlayerNoteStorage.saveNotes();
    }

    public static void forceSave() {
        PlayerNoteStorage.saveNotes();
    }

    static {
        PlayerNoteStorage.loadNotes();
    }

    @Environment(value=EnvType.CLIENT)
    private static class StorageData {
        Map<String, String> notes = new HashMap<String, String>();
        Set<String> favourites = new HashSet<String>();
        String pinnedPlayer = null;

        private StorageData() {
        }
    }
}

