/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ntf.NotesCommand;
import com.ntf.PinnedNoteManager;
import com.ntf.PlayerNoteStorage;
import com.ntf.PlayerNotesScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="ntf", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class NotesToSelfClient {
    private static KeyMapping openNotesKey;
    private static final Logger LOGGER;

    @SubscribeEvent
    public static void onKeyRegister(RegisterKeyMappingsEvent event) {
        openNotesKey = new KeyMapping("key.ntf.open_notes", 78, "key.categories.misc");
        event.register(openNotesKey);
    }

    public static void init() {
        LOGGER.info("Note This, loaded!");
        NeoForge.EVENT_BUS.addListener(NotesToSelfClient::onClientTick);
        NeoForge.EVENT_BUS.addListener(NotesToSelfClient::onRenderGuiOverlay);
        NeoForge.EVENT_BUS.addListener(NotesCommand::onRegisterCommands);
    }

    private static void onClientTick(LevelTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        if (client.level != null && event.getLevel() == client.level) {
            while (openNotesKey.consumeClick()) {
                client.setScreen((Screen)new PlayerNotesScreen());
            }
        }
    }

    private static void onRenderGuiOverlay(RenderGuiEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        if (client == null || client.options.hideGui || client.player == null) {
            return;
        }
        if (!PinnedNoteManager.isPinned()) {
            return;
        }
        String pinnedPlayer = PinnedNoteManager.getPinnedPlayer();
        String note = PlayerNoteStorage.getNote(pinnedPlayer);
        if (note == null || note.isEmpty()) {
            return;
        }
        GuiGraphics context = event.getGuiGraphics();
        int x = context.guiWidth() - 150;
        int y = context.guiHeight() - 150;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        context.fill(x - 6, y - 6, x + 150, y + 40, -16777216);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        context.drawString(client.font, (Component)Component.literal((String)("\ud83d\udccc " + pinnedPlayer + ": ")), x, y, -10496);
        context.drawString(client.font, (Component)Component.literal((String)note), x, y + 10, -1);
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"nts");
    }
}

